/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.time;

import com.azul.jvm.time.Time;
import com.azul.jvm.time.TimeStep;
import java.util.concurrent.TimeUnit;

public interface BaseTime<T extends BaseTime<T>>
extends Time {
    public T add(long var1, TimeUnit var3);

    default public T add(TimeStep timeStep) {
        return (T)this.add(timeStep.val, timeStep.unit);
    }

    default public T sub(long duration, TimeUnit unit) {
        return (T)this.add(-duration, unit);
    }

    default public T sub(TimeStep timeStep) {
        return (T)this.sub(timeStep.val, timeStep.unit);
    }

    default public T roundTo(TimeUnit unit) {
        return (T)this.roundTo(1L, unit);
    }

    default public T roundTo(TimeStep timeStep) {
        return (T)this.roundTo(timeStep.val, timeStep.unit);
    }

    public T roundTo(long var1, TimeUnit var3);

    default public T roundDown(TimeUnit unit) {
        return (T)this.roundTo(unit);
    }

    default public T roundDown(TimeStep timeStep) {
        return this.roundDown(timeStep.val, timeStep.unit);
    }

    default public T roundDown(long duration, TimeUnit unit) {
        return (T)this.roundTo(duration, unit);
    }

    default public T roundUp(TimeStep timeStep) {
        return this.roundUp(timeStep.val, timeStep.unit);
    }

    default public T roundUp(TimeUnit unit) {
        return (T)this.roundDown(unit).add(1L, unit);
    }

    default public T roundUp(long duration, TimeUnit unit) {
        return (T)this.roundDown(duration, unit).add(duration, unit);
    }

    public long diff(T var1, TimeUnit var2);

    @Override
    default public int compareTo(Time that) {
        BaseTime casted = (BaseTime)that;
        return this.compareTo((T)casted);
    }

    @Override
    public int compareTo(T var1);
}

