/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.advisor.api;

import java.util.Optional;

public class Advice
implements Comparable<Advice> {
    public final String advice;
    public final String recipe;
    public final Severity severity;
    public final Optional<String> url;
    public final Optional<String> lookupElement;

    public Advice(String advice, String recipe, Severity severity, String url, String lookupElement) {
        this.advice = advice;
        this.recipe = recipe;
        this.severity = severity;
        this.url = Optional.ofNullable(url);
        this.lookupElement = Optional.ofNullable(lookupElement);
    }

    public Advice(String advice, String recipe, Severity severity, String url) {
        this(advice, recipe, severity, url, null);
    }

    public Advice(String advice, String recipe) {
        this(advice, recipe, Severity.L2, null, null);
    }

    @Override
    public int compareTo(Advice that) {
        if (this.severity.ordinal() > that.severity.ordinal()) {
            return 1;
        }
        return -1;
    }

    public static enum Severity {
        L1("Recommendations"),
        L2("Observations");

        private final String category;

        private Severity(String s) {
            this.category = s;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

