/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.CPUTimesAggregator;
import com.azul.log.gctoolkitInterface.dtos.CPUTimesDTO;
import com.azul.log.gctoolkitInterface.general.TimestampedDataSet;
import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.HashMap;

@Collates(value=CPUTimesAggregator.class)
public class CPUTimesAggregation
extends Aggregation {
    private final HashMap<GarbageCollectionTypes, TimestampedDataSet<CPUTimesDTO>> data = new HashMap();

    public void recordCPUTime(GarbageCollectionTypes gcType, CPUTimesDTO cpuUses, DateTimeStamp timeStamp) {
        this.data.computeIfAbsent(gcType, key -> new TimestampedDataSet()).add(timeStamp, cpuUses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCPUTimeIfNotExist(GarbageCollectionTypes gcType, CPUTimesDTO cpuUses, DateTimeStamp timeStamp) {
        HashMap<GarbageCollectionTypes, TimestampedDataSet<CPUTimesDTO>> hashMap = this.data;
        synchronized (hashMap) {
            this.data.computeIfAbsent(gcType, key -> new TimestampedDataSet()).addIfAbsent(timeStamp, cpuUses);
        }
    }

    public HashMap<GarbageCollectionTypes, TimestampedDataSet<CPUTimesDTO>> getData() {
        return this.data;
    }

    @Override
    public boolean hasWarning() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

