/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.CPUTimesAggregation;
import com.azul.log.gctoolkitInterface.dtos.CPUTimesDTO;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.generational.CMSConcurrentEvent;
import com.microsoft.gctoolkit.event.generational.CMSPauseEvent;
import com.microsoft.gctoolkit.event.generational.GenerationalGCPauseEvent;

@Aggregates(value={EventSource.G1GC, EventSource.GENERATIONAL, EventSource.CMS_PREUNIFIED, EventSource.CMS_UNIFIED})
public class CPUTimesAggregator
extends Aggregator<CPUTimesAggregation> {
    public CPUTimesAggregator(CPUTimesAggregation aggregation) {
        super(aggregation);
        this.register(G1GCPauseEvent.class, this::extractCpuTime);
        this.register(GenerationalGCPauseEvent.class, this::extractCpuTime);
        this.register(CMSPauseEvent.class, this::extractCpuTime);
        this.register(CMSConcurrentEvent.class, this::extractCpuTime);
    }

    private void extractCpuTime(G1GCPauseEvent event) {
        if (event.getCpuSummary() == null) {
            return;
        }
        CPUTimesDTO cpuTimesDTO = new CPUTimesDTO(event.getCpuSummary().getUser(), event.getCpuSummary().getKernel(), event.getCpuSummary().getWallClock());
        ((CPUTimesAggregation)this.aggregation()).recordCPUTime(event.getGarbageCollectionType(), cpuTimesDTO, event.getDateTimeStamp());
    }

    private void extractCpuTime(GenerationalGCPauseEvent event) {
        if (event.getCpuSummary() == null) {
            return;
        }
        CPUTimesDTO cpuTimesDTO = new CPUTimesDTO(event.getCpuSummary().getUser(), event.getCpuSummary().getKernel(), event.getCpuSummary().getWallClock());
        if (event.getGarbageCollectionType() == GarbageCollectionTypes.ParNew) {
            ((CPUTimesAggregation)this.aggregation()).recordCPUTimeIfNotExist(event.getGarbageCollectionType(), cpuTimesDTO, event.getDateTimeStamp());
        } else {
            ((CPUTimesAggregation)this.aggregation()).recordCPUTime(event.getGarbageCollectionType(), cpuTimesDTO, event.getDateTimeStamp());
        }
    }

    private void extractCpuTime(CMSPauseEvent event) {
        if (event.getCpuSummary() == null) {
            return;
        }
        CPUTimesDTO cpuTimesDTO = new CPUTimesDTO(event.getCpuSummary().getUser(), event.getCpuSummary().getKernel(), event.getCpuSummary().getWallClock());
        ((CPUTimesAggregation)this.aggregation()).recordCPUTimeIfNotExist(event.getGarbageCollectionType(), cpuTimesDTO, event.getDateTimeStamp());
    }

    private void extractCpuTime(CMSConcurrentEvent event) {
        CPUTimesDTO cpuTimesDTO = new CPUTimesDTO(event.getCpuTime(), event.getWallClockTime());
        ((CPUTimesAggregation)this.aggregation()).recordCPUTime(event.getGarbageCollectionType(), cpuTimesDTO, event.getDateTimeStamp());
    }
}

