/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.ConcurrentTimesAggregation;
import com.azul.log.gctoolkitInterface.dtos.CMSConcurrentTimesDTO;
import com.azul.log.gctoolkitInterface.dtos.G1ConcurrentTimesDTO;
import com.azul.log.gctoolkitInterface.dtos.ZGCConcurrentTimesDTO;
import com.azul.log.gctoolkitInterface.general.enums.GenerationType;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCleanupForNextMark;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentClearClaimedMarks;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCompleteCleanup;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCreateLiveData;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentScanRootRegion;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentCleanup;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMark;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMarkResetForOverflow;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentRebuildRememberedSets;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentStringDeduplication;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentUndoCycle;
import com.microsoft.gctoolkit.event.g1gc.G1GCConcurrentEvent;
import com.microsoft.gctoolkit.event.generational.AbortablePreClean;
import com.microsoft.gctoolkit.event.generational.CMSConcurrentEvent;
import com.microsoft.gctoolkit.event.generational.ConcurrentMark;
import com.microsoft.gctoolkit.event.generational.ConcurrentPreClean;
import com.microsoft.gctoolkit.event.generational.ConcurrentReset;
import com.microsoft.gctoolkit.event.generational.ConcurrentSweep;
import com.microsoft.gctoolkit.event.zgc.FullZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MajorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MinorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCCycle;
import com.microsoft.gctoolkit.time.DateTimeStamp;

@Aggregates(value={EventSource.G1GC, EventSource.ZGC, EventSource.CMS_PREUNIFIED, EventSource.CMS_UNIFIED})
public class ConcurrentTimesAggregator
extends Aggregator<ConcurrentTimesAggregation> {
    public ConcurrentTimesAggregator(ConcurrentTimesAggregation aggregation) {
        super(aggregation);
        this.register(ConcurrentClearClaimedMarks.class, this::process);
        this.register(ConcurrentScanRootRegion.class, this::process);
        this.register(G1ConcurrentMark.class, this::process);
        this.register(G1ConcurrentRebuildRememberedSets.class, this::process);
        this.register(ConcurrentCleanupForNextMark.class, this::process);
        this.register(ConcurrentCompleteCleanup.class, this::process);
        this.register(ConcurrentCreateLiveData.class, this::process);
        this.register(G1ConcurrentCleanup.class, this::process);
        this.register(G1ConcurrentMarkResetForOverflow.class, this::process);
        this.register(G1ConcurrentStringDeduplication.class, this::process);
        this.register(G1GCConcurrentEvent.class, this::process);
        this.register(G1ConcurrentUndoCycle.class, this::process);
        this.register(FullZGCCycle.class, this::process);
        this.register(MajorZGCCycle.class, this::process);
        this.register(MinorZGCCycle.class, this::process);
        this.register(ConcurrentPreClean.class, this::process);
        this.register(AbortablePreClean.class, this::process);
        this.register(ConcurrentMark.class, this::process);
        this.register(ConcurrentReset.class, this::process);
        this.register(ConcurrentSweep.class, this::process);
        this.register(CMSConcurrentEvent.class, this::process);
    }

    private void process(G1GCConcurrentEvent event) {
        System.out.println("Unhandled G1 concurrent event " + event.toString());
    }

    private void process(ConcurrentClearClaimedMarks event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setClearClaimedMarksDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentScanRootRegion event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setScanRootRegionDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentMark event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setMarkDuration(event.getDuration());
        concurrentTimesDTO.setMarkFromRootDuration(event.getMarkFromRootsDuration());
        concurrentTimesDTO.setPrecleanDuration(event.getPrecleanDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentRebuildRememberedSets event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setRebuildRememberedSetsDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentCleanupForNextMark event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setCleanupForNextMarkDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentCompleteCleanup event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setCompleteCleanupDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentCreateLiveData event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setCreateLiveDataDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentCleanup event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setCleanupDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentMarkResetForOverflow event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setMarkResetForOverflowDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentStringDeduplication event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setStringDeduplicationDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentUndoCycle event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setUndoCycleDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(FullZGCCycle event) {
        ZGCConcurrentTimesDTO concurrentTimesDTO = new ZGCConcurrentTimesDTO(GenerationType.FULL);
        concurrentTimesDTO.setProcessNonStrongRefs(event.getConcurrentProcessNonStrongReferencesDuration());
        concurrentTimesDTO.setResetRelocationSet(event.getConcurrentResetRelocationSetDuration());
        concurrentTimesDTO.setSelectRelocationSet(event.getConcurrentSelectRelocationSetDuration());
        concurrentTimesDTO.setRelocate(event.getConcurrentRelocateDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void processZGCCycle(ZGCCycle cycle, GenerationType generation, DateTimeStamp timeStamp) {
        ZGCConcurrentTimesDTO concurrentTimesDTO = new ZGCConcurrentTimesDTO(generation);
        if (cycle.getConcurrentProcessNonStrongReferencesTimeStamp() != null) {
            concurrentTimesDTO.setProcessNonStrongRefs(cycle.getConcurrentProcessNonStrongReferencesDuration());
        }
        if (cycle.getConcurrentResetRelocationSetTimeStamp() != null) {
            concurrentTimesDTO.setResetRelocationSet(cycle.getConcurrentResetRelocationSetDuration());
        }
        if (cycle.getConcurrentSelectRelocationSetTimeStamp() != null) {
            concurrentTimesDTO.setSelectRelocationSet(cycle.getConcurrentSelectRelocationSetDuration());
        }
        if (cycle.getConcurrentRelocateTimeStamp() != null) {
            concurrentTimesDTO.setRelocate(cycle.getConcurrentRelocateDuration());
        }
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, timeStamp);
    }

    private void process(MajorZGCCycle event) {
        this.processZGCCycle(event.getYoungCycle(), GenerationType.YOUNG, event.getDateTimeStamp());
        this.processZGCCycle(event.getOldCycle(), GenerationType.OLD, event.getDateTimeStamp());
    }

    private void process(MinorZGCCycle event) {
        this.processZGCCycle(event.getYoungCycle(), GenerationType.YOUNG, event.getDateTimeStamp());
    }

    private void process(ConcurrentPreClean event) {
        CMSConcurrentTimesDTO concurrentTimesDTO = new CMSConcurrentTimesDTO();
        concurrentTimesDTO.setConcurrentPreClean(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(AbortablePreClean event) {
        CMSConcurrentTimesDTO concurrentTimesDTO = new CMSConcurrentTimesDTO();
        concurrentTimesDTO.setAbortablePreClean(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentMark event) {
        CMSConcurrentTimesDTO concurrentTimesDTO = new CMSConcurrentTimesDTO();
        concurrentTimesDTO.setConcurrentMark(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentReset event) {
        CMSConcurrentTimesDTO concurrentTimesDTO = new CMSConcurrentTimesDTO();
        concurrentTimesDTO.setConcurrentReset(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentSweep event) {
        CMSConcurrentTimesDTO concurrentTimesDTO = new CMSConcurrentTimesDTO();
        concurrentTimesDTO.setConcurrentSweep(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(CMSConcurrentEvent event) {
        System.out.println("Unhandled CMS concurrent event " + event.toString());
    }
}

