/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.HeapAndMetaspaceAggregation;
import com.azul.log.gctoolkitInterface.dtos.MemoryUsesDTO;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.generational.CMSPauseEvent;
import com.microsoft.gctoolkit.event.generational.GenerationalGCPauseEvent;
import com.microsoft.gctoolkit.event.zgc.FullZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MajorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MinorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCMetaspaceSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCReclaimSummary;
import com.microsoft.gctoolkit.time.DateTimeStamp;

@Aggregates(value={EventSource.G1GC, EventSource.GENERATIONAL, EventSource.ZGC, EventSource.CMS_PREUNIFIED, EventSource.CMS_UNIFIED})
public class HeapAndMetaspaceAggregator
extends Aggregator<HeapAndMetaspaceAggregation> {
    public HeapAndMetaspaceAggregator(HeapAndMetaspaceAggregation aggregation) {
        super(aggregation);
        this.register(GenerationalGCPauseEvent.class, this::extractMemoryUses);
        this.register(G1GCPauseEvent.class, this::extractMemoryUses);
        this.register(FullZGCCycle.class, this::extractMemoryUses);
        this.register(MajorZGCCycle.class, this::extractMemoryUses);
        this.register(MinorZGCCycle.class, this::extractMemoryUses);
        this.register(CMSPauseEvent.class, this::extractMemoryUses);
    }

    private void extractMemoryUses(GenerationalGCPauseEvent event) {
        MemoryUsesDTO memoryUseDTO = new MemoryUsesDTO();
        if (event.getHeap() != null) {
            memoryUseDTO.setHeapBefore(event.getHeap().getOccupancyBeforeCollection());
            memoryUseDTO.setHeapAfter(event.getHeap().getOccupancyAfterCollection());
            memoryUseDTO.setHeapTargetBefore(event.getHeap().getSizeBeforeCollection());
        }
        if (event.getYoung() != null) {
            memoryUseDTO.setEdenBefore(event.getYoung().getOccupancyBeforeCollection());
            memoryUseDTO.setEdenAfter(event.getYoung().getOccupancyAfterCollection());
            memoryUseDTO.setEdenTargetBefore(event.getYoung().getSizeBeforeCollection());
        }
        if (event.getTenured() != null) {
            memoryUseDTO.setOldBefore(event.getTenured().getOccupancyBeforeCollection());
            memoryUseDTO.setOldAfter(event.getTenured().getOccupancyAfterCollection());
            memoryUseDTO.setOldTarget(event.getTenured().getSizeBeforeCollection());
        }
        if (event.getPermOrMetaspace() != null) {
            memoryUseDTO.setMetaspaceTotalCapacityBefore(event.getPermOrMetaspace().getSizeBeforeCollection());
            memoryUseDTO.setMetaspaceTotalUseBefore(event.getPermOrMetaspace().getOccupancyBeforeCollection());
            memoryUseDTO.setMetaspaceTotalCapacityAfter(event.getPermOrMetaspace().getSizeAfterCollection());
            memoryUseDTO.setMetaspaceTotalUseAfter(event.getPermOrMetaspace().getOccupancyAfterCollection());
        }
        if (event.getClassspace() != null) {
            memoryUseDTO.setMetaspaceClassCapacityBefore(event.getClassspace().getSizeBeforeCollection());
            memoryUseDTO.setMetaspaceClassUseBefore(event.getClassspace().getOccupancyBeforeCollection());
            memoryUseDTO.setMetaspaceClassCapacityAfter(event.getClassspace().getSizeAfterCollection());
            memoryUseDTO.setMetaspaceClassUseAfter(event.getClassspace().getOccupancyAfterCollection());
        }
        if (event.getNonClassspace() != null) {
            memoryUseDTO.setMetaspaceNonClassCapacityBefore(event.getNonClassspace().getSizeBeforeCollection());
            memoryUseDTO.setMetaspaceNonClassUseBefore(event.getNonClassspace().getOccupancyBeforeCollection());
            memoryUseDTO.setMetaspaceNonClassCapacityAfter(event.getNonClassspace().getSizeAfterCollection());
            memoryUseDTO.setMetaspaceNonClassUseAfter(event.getNonClassspace().getOccupancyAfterCollection());
        }
        if (event.getGarbageCollectionType() == GarbageCollectionTypes.ParNew) {
            ((HeapAndMetaspaceAggregation)this.aggregation()).recordMemoryUseIfNotExist(event.getGarbageCollectionType(), memoryUseDTO, event.getDateTimeStamp());
        } else {
            ((HeapAndMetaspaceAggregation)this.aggregation()).recordMemoryUse(event.getGarbageCollectionType(), memoryUseDTO, event.getDateTimeStamp());
        }
    }

    private void extractMemoryUses(G1GCPauseEvent event) {
        MemoryUsesDTO memoryUseDTO = new MemoryUsesDTO();
        if (event.getHeap() != null) {
            memoryUseDTO.setHeapBefore(event.getHeap().getOccupancyBeforeCollection());
            memoryUseDTO.setHeapAfter(event.getHeap().getOccupancyAfterCollection());
            memoryUseDTO.setHeapTargetBefore(event.getHeap().getSizeBeforeCollection());
            memoryUseDTO.setHeapTargetAfter(event.getHeap().getSizeAfterCollection());
        }
        if (event.getEden() != null) {
            memoryUseDTO.setEdenBefore(event.getEden().getOccupancyBeforeCollection());
            memoryUseDTO.setEdenAfter(event.getEden().getOccupancyAfterCollection());
            memoryUseDTO.setEdenTargetBefore(event.getEden().getSizeBeforeCollection());
            memoryUseDTO.setEdenTargetAfter(event.getEden().getSizeAfterCollection());
        } else if (event.getEdenRegionSummary() != null) {
            memoryUseDTO.setEdenBefore(event.getEdenRegionSummary().getBefore());
            memoryUseDTO.setEdenAfter(event.getEdenRegionSummary().getAfter());
            memoryUseDTO.setEdenTargetBefore(event.getEdenRegionSummary().getAssigned());
        }
        if (event.getOldRegionSummary() != null) {
            memoryUseDTO.setOldBefore(event.getOldRegionSummary().getBefore());
            memoryUseDTO.setOldAfter(event.getOldRegionSummary().getAfter());
            memoryUseDTO.setOldTarget(event.getOldRegionSummary().getAssigned());
        }
        if (event.getSurvivor() != null) {
            memoryUseDTO.setSurvivalBefore(event.getSurvivor().getOccupancyBeforeCollection());
            memoryUseDTO.setSurvivalAfter(event.getSurvivor().getOccupancyAfterCollection());
            memoryUseDTO.setSurvivalTarget(event.getSurvivor().getSize());
        } else if (event.getSurvivorRegionSummary() != null) {
            memoryUseDTO.setSurvivalBefore(event.getSurvivorRegionSummary().getBefore());
            memoryUseDTO.setSurvivalAfter(event.getSurvivorRegionSummary().getAfter());
            memoryUseDTO.setSurvivalTarget(event.getSurvivorRegionSummary().getAssigned());
        }
        if (event.getHumongousRegionSummary() != null) {
            memoryUseDTO.setHumongousBefore(event.getHumongousRegionSummary().getBefore());
            memoryUseDTO.setHumongousAfter(event.getHumongousRegionSummary().getAfter());
            memoryUseDTO.setHumongousTarget(event.getHumongousRegionSummary().getAssigned());
        }
        if (event.getPermOrMetaspace() != null) {
            memoryUseDTO.setMetaspaceTotalUseBefore(event.getPermOrMetaspace().getOccupancyBeforeCollection());
            memoryUseDTO.setMetaspaceTotalUseAfter(event.getPermOrMetaspace().getOccupancyAfterCollection());
            memoryUseDTO.setMetaspaceTotalCapacityBefore(event.getPermOrMetaspace().getSizeBeforeCollection());
            memoryUseDTO.setMetaspaceTotalCapacityAfter(event.getPermOrMetaspace().getSizeAfterCollection());
        }
        ((HeapAndMetaspaceAggregation)this.aggregation()).recordMemoryUse(event.getGarbageCollectionType(), memoryUseDTO, event.getDateTimeStamp());
    }

    private void extractMemoryUses(FullZGCCycle event) {
        ZGCMetaspaceSummary metaspaceSummary;
        MemoryUsesDTO memoryUsesDTO = new MemoryUsesDTO();
        ZGCReclaimSummary reclaimSummary = event.getReclaimSummary();
        if (reclaimSummary != null) {
            memoryUsesDTO.setHeapBefore(reclaimSummary.getReclaimStart());
            memoryUsesDTO.setHeapAfter(reclaimSummary.getReclaimEnd());
        }
        if ((metaspaceSummary = event.getMetaspaceSummary()) != null) {
            memoryUsesDTO.setMetaspaceTotalUseAfter(metaspaceSummary.getUsed());
            memoryUsesDTO.setMetaspaceTotalCapacityBefore(metaspaceSummary.getCommitted());
            memoryUsesDTO.setMetaspaceTotalCapacityAfter(metaspaceSummary.getReserved());
        }
        ((HeapAndMetaspaceAggregation)this.aggregation()).recordMemoryUse(event.getGarbageCollectionType(), memoryUsesDTO, event.getDateTimeStamp());
    }

    private void processZGCCycle(ZGCCycle cycle, GarbageCollectionTypes gc, DateTimeStamp timeStamp) {
        ZGCMetaspaceSummary metaspaceSummary;
        MemoryUsesDTO memoryUsesDTO = new MemoryUsesDTO();
        ZGCReclaimSummary reclaimSummary = cycle.getReclaimSummary();
        if (reclaimSummary != null) {
            memoryUsesDTO.setHeapBefore(reclaimSummary.getReclaimStart());
            memoryUsesDTO.setHeapAfter(reclaimSummary.getReclaimEnd());
        }
        if ((metaspaceSummary = cycle.getMetaspaceSummary()) != null) {
            memoryUsesDTO.setMetaspaceTotalUseAfter(metaspaceSummary.getUsed());
            memoryUsesDTO.setMetaspaceTotalCapacityBefore(metaspaceSummary.getCommitted());
            memoryUsesDTO.setMetaspaceTotalCapacityAfter(metaspaceSummary.getReserved());
        }
        ((HeapAndMetaspaceAggregation)this.aggregation()).recordMemoryUse(gc, memoryUsesDTO, timeStamp);
    }

    private void extractMemoryUses(MajorZGCCycle event) {
        this.processZGCCycle(event.getYoungCycle(), event.getGarbageCollectionType(), event.getDateTimeStamp());
        this.processZGCCycle(event.getOldCycle(), event.getGarbageCollectionType(), event.getDateTimeStamp());
    }

    private void extractMemoryUses(MinorZGCCycle event) {
        this.processZGCCycle(event.getYoungCycle(), event.getGarbageCollectionType(), event.getDateTimeStamp());
    }

    private void extractMemoryUses(CMSPauseEvent event) {
        MemoryUsesDTO memoryUsesDTO = new MemoryUsesDTO();
        if (event.getHeap() != null) {
            memoryUsesDTO.setHeapBefore(event.getHeap().getOccupancyBeforeCollection());
            memoryUsesDTO.setHeapTargetBefore(event.getHeap().getSizeBeforeCollection());
            memoryUsesDTO.setHeapAfter(event.getHeap().getOccupancyAfterCollection());
            memoryUsesDTO.setHeapTargetAfter(event.getHeap().getSizeAfterCollection());
        }
        if (event.getYoung() != null) {
            memoryUsesDTO.setEdenBefore(event.getYoung().getOccupancyBeforeCollection());
            memoryUsesDTO.setEdenTargetBefore(event.getYoung().getSizeBeforeCollection());
            memoryUsesDTO.setEdenAfter(event.getYoung().getOccupancyAfterCollection());
            memoryUsesDTO.setEdenTargetAfter(event.getYoung().getSizeAfterCollection());
        }
        if (event.getTenured() != null) {
            memoryUsesDTO.setOldBefore(event.getTenured().getOccupancyBeforeCollection());
            memoryUsesDTO.setOldTarget(event.getTenured().getSizeBeforeCollection());
            memoryUsesDTO.setOldAfter(event.getTenured().getOccupancyAfterCollection());
            memoryUsesDTO.setOldTargetAfter(event.getTenured().getSizeAfterCollection());
        }
        ((HeapAndMetaspaceAggregation)this.aggregation()).recordMemoryUseIfNotExist(event.getGarbageCollectionType(), memoryUsesDTO, event.getDateTimeStamp());
    }
}

