/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.general;

import com.azul.log.gctoolkitInterface.aggregations.AppStoppedTimeAggregation;
import com.azul.log.gctoolkitInterface.aggregations.CPUTimesAggregation;
import com.azul.log.gctoolkitInterface.aggregations.CompactionTimesAggregation;
import com.azul.log.gctoolkitInterface.aggregations.ConcurrentTimesAggregation;
import com.azul.log.gctoolkitInterface.aggregations.EvacuationPhaseAggregation;
import com.azul.log.gctoolkitInterface.aggregations.G1PhaseTimesAggregation;
import com.azul.log.gctoolkitInterface.aggregations.HeapAndMetaspaceAggregation;
import com.azul.log.gctoolkitInterface.aggregations.PauseAggregation;
import com.azul.log.gctoolkitInterface.aggregations.WorkersAggregation;
import com.azul.log.gctoolkitInterface.general.enums.SUMMARY_FIELD;
import com.azul.log.gctoolkitInterface.general.enums.VMVersion;
import com.azul.log.parser.utils.TextUtils;
import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.io.SingleGCLogFile;
import com.microsoft.gctoolkit.jvm.JavaVirtualMachine;
import io.vertx.core.impl.DeploymentManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class GCToolkitConnector {
    public static long PHASE_DURATION_SCALE = 1000000000L;
    public static long DURATION_SCALE = 1000000L;
    private static GCToolkitConnector instance;
    private static Path path;
    private static JavaVirtualMachine jvm;
    private static SingleGCLogFile logFile;
    private static final List<Logger> blockedLoggers;

    private GCToolkitConnector(Path path) {
        try {
            logFile = new SingleGCLogFile(path);
            GCToolKit gcToolKit = new GCToolKit();
            gcToolKit.loadAggregation(new HeapAndMetaspaceAggregation());
            gcToolKit.loadAggregation(new PauseAggregation());
            gcToolKit.loadAggregation(new CPUTimesAggregation());
            gcToolKit.loadAggregation(new WorkersAggregation());
            gcToolKit.loadAggregation(new EvacuationPhaseAggregation());
            gcToolKit.loadAggregation(new G1PhaseTimesAggregation());
            gcToolKit.loadAggregation(new CompactionTimesAggregation());
            gcToolKit.loadAggregation(new ConcurrentTimesAggregation());
            gcToolKit.loadAggregation(new AppStoppedTimeAggregation());
            jvm = gcToolKit.analyze(logFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void filterOutLogs() {
        Consumer<String> stopLogger = clazz -> {
            Logger logger = Logger.getLogger(clazz);
            logger.setUseParentHandlers(false);
            blockedLoggers.add(logger);
        };
        stopLogger.accept(DeploymentManager.class.getName());
        stopLogger.accept("com.microsoft.gctoolkit");
    }

    public static JavaVirtualMachine initialize(Path initPath) {
        GCToolkitConnector.filterOutLogs();
        if (instance == null || path != initPath) {
            instance = new GCToolkitConnector(initPath);
            path = initPath;
        }
        return GCToolkitConnector.getJvm();
    }

    public static JavaVirtualMachine getJvm() {
        return jvm;
    }

    public static GCLogFile getLogFile() {
        return logFile;
    }

    public static String getVMLine() {
        String vmLine = "n/a";
        try {
            Optional<String> foundLine;
            if (logFile != null && (foundLine = logFile.stream().filter(line -> line.startsWith("Java HotSpot(TM)") || line.startsWith("OpenJDK")).findFirst()).isPresent()) {
                vmLine = foundLine.get();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vmLine;
    }

    public static VMVersion getJVMVersion() {
        try {
            if (logFile == null || logFile.diary() == null) {
                return VMVersion.UNKNOWN;
            }
            if (logFile.diary().isJDK70()) {
                return VMVersion.JDK70;
            }
            if (logFile.diary().isJDK80()) {
                return VMVersion.JDK80;
            }
            return VMVersion.JDK90;
        }
        catch (IOException iOException) {
            return VMVersion.UNKNOWN;
        }
    }

    public static List<String> getCommandLineFlags() {
        List<String> flags = new ArrayList<String>();
        try {
            Optional<String> foundLine;
            if (logFile != null && (foundLine = logFile.stream().filter(line -> line.startsWith("CommandLine flags: ")).findFirst()).isPresent()) {
                flags = List.of(foundLine.get().replace("CommandLine flags: ", "").split(" "));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flags;
    }

    public static String getInfo(SUMMARY_FIELD field) {
        String keyword = field.get();
        String infoLine = "n/a";
        try {
            Optional<String> foundLine;
            if (logFile != null && (foundLine = logFile.stream().filter(line -> TextUtils.indexOfIgnoreCase(line, keyword, 0) >= 0).findFirst()).isPresent()) {
                int idx = TextUtils.indexOfIgnoreCase(foundLine.get(), keyword, 0);
                infoLine = foundLine.get().substring(idx + keyword.length()).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return infoLine;
    }

    static {
        blockedLoggers = new ArrayList<Logger>();
    }
}

