/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.general;

import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimestampedDataSet<T> {
    protected final List<Point<T>> dataSeries;

    public TimestampedDataSet() {
        this.dataSeries = new ArrayList<Point<T>>();
    }

    public TimestampedDataSet(TimestampedDataSet<T> series) {
        this.dataSeries = new ArrayList<Point<T>>(series.getItems());
    }

    public TimestampedDataSet(List<Point<T>> series) {
        this.dataSeries = series;
    }

    public void add(DateTimeStamp timestamp, T value) {
        this.dataSeries.add(new Point<T>(timestamp, value));
    }

    public void addIfAbsent(DateTimeStamp timestamp, T value) {
        Point<T> point = new Point<T>(timestamp, value);
        if (!this.dataSeries.contains(point)) {
            this.dataSeries.add(point);
        }
    }

    public void add(Point<T> item) {
        this.dataSeries.add(item);
    }

    public static <T> TimestampedDataSet<T> combine(TimestampedDataSet<T> firstSet, TimestampedDataSet<T> secondSet) {
        if (firstSet == null || firstSet.isEmpty()) {
            return secondSet;
        }
        if (secondSet == null || secondSet.isEmpty()) {
            return firstSet;
        }
        ArrayList<Point<T>> merged = new ArrayList<Point<T>>(firstSet.dataSeries.size() + secondSet.dataSeries.size());
        int i = 0;
        int j = 0;
        List<Point<T>> a = firstSet.dataSeries;
        List<Point<T>> b = secondSet.dataSeries;
        while (i < a.size() && j < b.size()) {
            if (a.get((int)i).dateTimeStamp.getTimeStamp() <= b.get((int)j).dateTimeStamp.getTimeStamp()) {
                merged.add(a.get(i++));
                continue;
            }
            merged.add(b.get(j++));
        }
        while (i < a.size()) {
            merged.add(a.get(i++));
        }
        while (j < b.size()) {
            merged.add(b.get(j++));
        }
        return new TimestampedDataSet<T>(merged);
    }

    public boolean isEmpty() {
        return this.dataSeries.isEmpty();
    }

    public List<Point<T>> getItems() {
        return this.dataSeries;
    }

    public int size() {
        return this.dataSeries.size();
    }

    public static class Point<T> {
        private final DateTimeStamp dateTimeStamp;
        private final T value;

        public Point(DateTimeStamp dateTimeStamp, T value) {
            this.dateTimeStamp = dateTimeStamp;
            this.value = value;
        }

        public long getAbsoluteTimestamp() {
            return (long)this.dateTimeStamp.toEpochInMillis();
        }

        public double getRelativeTimestamp() {
            return this.dateTimeStamp.getTimeStamp();
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.dateTimeStamp + "," + this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Point otherPoint = (Point)obj;
            return Objects.equals(this.dateTimeStamp, otherPoint.dateTimeStamp);
        }
    }
}

