/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.actions;

import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.ToolbarButton;
import com.azul.log.parser.utils.TextUtils;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public final class ItemSelectionActions {
    private static final UIElementSelectionModel model = UIElementSelectionModel.getInstance();
    public static final AbstractAction NEXT = new ItemSelectionAction(KeyStroke.getKeyStroke(39, 64), "next"){

        @Override
        public void actionPerformed(ActionEvent e) {
            model.selectNext();
        }

        @Override
        public boolean isEnabled() {
            return model.hasNext();
        }
    };
    public static final AbstractAction PREVIOUS = new ItemSelectionAction(KeyStroke.getKeyStroke(37, 64), "previous"){

        @Override
        public void actionPerformed(ActionEvent e) {
            model.selectPrevious();
        }

        @Override
        public boolean isEnabled() {
            return model.hasPrevious();
        }
    };
    public static final AbstractAction CLEAR = new ItemSelectionAction(KeyStroke.getKeyStroke(27, 0), "clear"){

        @Override
        public void actionPerformed(ActionEvent e) {
            model.clearSelection();
        }

        @Override
        public boolean isEnabled() {
            return model.getSelectedElement() != null;
        }
    };

    private ItemSelectionActions() {
    }

    public static AbstractButton getToolbarPresenter(AbstractAction action) throws IllegalArgumentException {
        if (!(action instanceof ItemSelectionAction)) {
            throw new IllegalArgumentException();
        }
        ItemSelectionAction a = (ItemSelectionAction)action;
        String label = KeyEvent.getModifiersExText(a.keyStroke.getModifiers()) + "+" + KeyEvent.getKeyText(a.keyStroke.getKeyCode());
        String tooltip = "Select " + TextUtils.toCamelCase(a.name) + " Item (" + label + ")";
        ToolbarButton btn = new ToolbarButton(action, tooltip, a.name);
        btn.setEnabled(false);
        return btn;
    }

    public static KeyStroke getKeystroke(AbstractAction action) throws IllegalArgumentException {
        if (!(action instanceof ItemSelectionAction)) {
            throw new IllegalArgumentException();
        }
        return ((ItemSelectionAction)action).keyStroke;
    }

    public static void registerActions(ActionMap actionMap, InputMap inputMap) {
        actionMap.put("selectNext", NEXT);
        actionMap.put("selectPrev", PREVIOUS);
        actionMap.put("clearSelection", CLEAR);
        inputMap.put(ItemSelectionActions.getKeystroke(NEXT), "selectNext");
        inputMap.put(ItemSelectionActions.getKeystroke(PREVIOUS), "selectPrev");
        inputMap.put(ItemSelectionActions.getKeystroke(CLEAR), "clearSelection");
    }

    private static abstract class ItemSelectionAction
    extends AbstractAction {
        private final KeyStroke keyStroke;
        private final String name;

        public ItemSelectionAction(KeyStroke keyStroke, String name) {
            this.name = name;
            this.keyStroke = keyStroke;
            model.addChangeListener(e -> this.setEnabled(this.isEnabled()));
        }
    }
}

