/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.config.api;

import com.azul.log.gui.model.FavoriteGraphsModel;
import com.azul.log.gui.model.GraphsSelectorModel;
import com.azul.log.gui.model.Model;
import com.azul.log.gui.model.PersistentModel;
import com.azul.log.gui.model.RecentOpenFilesModel;
import com.azul.log.gui.model.ScratchpadsSelectionModel;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public final class Config {
    public static final String PROPERTY_DRAW_EVENT_PHASES = "DRAW_EVENT_PHASES";
    public static final String PROPERTY_LAST_SELECTED_DIR = "LAST_SELECTED_DIR";
    public static final String PROPERTY_SHOW_ITEM_NUM_IN_TOOLTIP = "SHOW_ITEM_NUM_IN_TOOLTIP";
    public static final String PROPERTY_USE_GC_TYPE_SPECIFIC_SHAPES = "USE_GC_TYPE_SPECIFIC_SHAPES";
    private static final String userHome = System.getProperty("user.home");
    private static final String configDirName = ".gcla2";
    private static final String configFileName = "gcla.properties";
    private static final Properties props = new Properties();
    private static final ScheduledExecutorService exec = Executors.newScheduledThreadPool(1);
    private static final PropertyChangeSupport pcs = new PropertyChangeSupport(Config.class);
    private static ScheduledFuture<?> task;

    private Config() {
    }

    public static Path getConfigDir() {
        return Paths.get(userHome, configDirName);
    }

    private static File getConfigDirFile() {
        return Config.getConfigDir().toFile();
    }

    private static File getConfigFile() {
        return Config.getConfigDir().resolve(configFileName).toFile();
    }

    public static void init() {
        File configDir = Config.getConfigDirFile();
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Cannot create '" + configDir + "'");
        }
        ChangeListener modelsListener = e -> {
            try {
                Object source = e.getSource();
                if (source instanceof PersistentModel) {
                    PersistentModel model = (PersistentModel)source;
                    Config.storeProperty(model.getPersistentID(), model.toExternalString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        Config.init(RecentOpenFilesModel.getModel(), modelsListener);
        Config.init(FavoriteGraphsModel.getModel(), modelsListener);
        Config.init(GraphsSelectorModel.getModel(), modelsListener);
        Config.init(ScratchpadsSelectionModel.getModel(), modelsListener);
    }

    private static void init(PersistentModel model, ChangeListener listener) {
        model.initFromExternalString(Config.loadProperty(model.getPersistentID()));
        if (model instanceof Model) {
            ((Model)((Object)model)).addChangeListener(listener);
        }
    }

    public static <T extends Enum<T>> T getProperty(String prop, T dflt) {
        String v = Config.loadProperty(prop);
        if (v != null) {
            try {
                return Enum.valueOf(dflt.getDeclaringClass(), v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dflt;
    }

    public static <T extends Enum<T>> void setProperty(String prop, T val) {
        Config.storeProperty(prop, val.name());
    }

    public static boolean isActive(String propertyName) {
        return "1".equals(Config.loadProperty(propertyName));
    }

    public static void setActive(String propertyName, boolean active) {
        Config.storeProperty(propertyName, active ? "1" : "0");
    }

    public static String getProperty(String propertyName) {
        return Config.loadProperty(propertyName);
    }

    public static void setProperty(String propertyName, String propertyValue) {
        Config.storeProperty(propertyName, propertyValue);
    }

    public static String getLastSelectedDir() {
        return Config.loadProperty(PROPERTY_LAST_SELECTED_DIR);
    }

    public static void setLastSelectedDir(String dir) {
        Config.storeProperty(PROPERTY_LAST_SELECTED_DIR, dir);
    }

    private static synchronized void storeProperty(String propertyName, String newValue) {
        Object oldValue;
        if (newValue == null ? (oldValue = props.remove(propertyName)) == null : newValue.equals(oldValue = props.setProperty(propertyName, newValue))) {
            return;
        }
        SwingUtilities.invokeLater(() -> pcs.firePropertyChange(propertyName, oldValue, newValue));
        if (task != null) {
            task.cancel(false);
        }
        task = exec.schedule(() -> {
            try (FileOutputStream fos = new FileOutputStream(Config.getConfigFile());){
                props.store(fos, configDirName);
            }
            catch (IOException ex) {
                Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static synchronized String loadProperty(String propertyName) {
        if (props.isEmpty()) {
            try (FileInputStream fis2 = new FileInputStream(Config.getConfigFile());){
                props.load(fis2);
            }
            catch (FileNotFoundException fis2) {
            }
            catch (IOException ex) {
                Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return props.getProperty(propertyName);
    }

    public static int getIntProperty(String propertyName, int defaultValue) {
        Integer result = null;
        String value = Config.getProperty(propertyName);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result == null ? defaultValue : result;
    }

    public static Color getColorProperty(String propertyName, Color defaultValue) {
        Color result = null;
        String value = Config.getProperty(propertyName);
        if (value != null) {
            try {
                result = Color.decode(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result == null ? defaultValue : result;
    }

    public static void bind(JComponent comp, String property, PersistentModel model) {
        String prop = Config.loadProperty(model.getPersistentID());
        if (prop != null) {
            model.initFromExternalString(prop);
        }
        comp.addPropertyChangeListener(property, e -> Config.storeProperty(model.getPersistentID(), model.toExternalString()));
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(property, listener);
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(property, listener);
    }
}

