/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.graphs.annotations;

import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface GraphDescription {
    public String title();

    public int position() default 0x7FFFFFFF;

    public GraphSeries[] series();

    public LogUnits units();

    public String xlabel() default "Elapsed Time";

    public String ylabel() default "";

    public Class<? extends LogRecordLabelConverter> label_converter() default DefaultLabelConverter.class;

    public Class<? extends SeriesComparator> series_comparator() default SeriesComparator.Default.class;

    public Class<? extends GraphDescriptionFilter> filter() default DefaultGraphDescriptionFilter.class;

    public static final class DefaultGraphDescriptionFilter
    implements GraphDescriptionFilter {
        @Override
        public boolean isApplicable(LogModel logModel) {
            return true;
        }
    }

    public static final class DefaultLabelConverter
    implements LogRecordLabelConverter {
        @Override
        public String convert(double value) {
            throw new InternalError("Should not be called");
        }

        @Override
        public String[] getLabels() {
            throw new InternalError("Should not be called");
        }
    }
}

