/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import java.util.ArrayList;
import java.util.List;

public class LogLineOffsetMap {
    private static final int LOG = 12;
    private static final int BUCKET_SIZE = 4096;
    private static final int IDX_MASK = 4095;
    private final List<long[]> list = new ArrayList<long[]>();
    private long[] bucket = null;
    private int bucket_idx = 4096;
    private int total_size = 0;

    public static LogLineOffsetMap unmodifiable(final LogLineOffsetMap fromMap) {
        return new LogLineOffsetMap(){

            @Override
            public void push(int fileIndex, long offsetInFile) {
                throw new IllegalAccessError();
            }

            @Override
            public FileOffset getFileOffset(int lineNumber) {
                return fromMap.getFileOffset(lineNumber);
            }

            @Override
            public boolean isEmpty() {
                return fromMap.isEmpty();
            }

            @Override
            public int size() {
                return fromMap.size();
            }
        };
    }

    public void push(int fileIndex, long offsetInFile) {
        if (this.bucket_idx == 4096) {
            this.bucket = new long[4096];
            this.list.add(this.bucket);
            this.bucket_idx = 0;
        }
        this.bucket[this.bucket_idx++] = offsetInFile << 8 | (long)fileIndex;
        ++this.total_size;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public FileOffset getFileOffset(int lineNumber) {
        int lineIndex = lineNumber > 0 ? lineNumber - 1 : 0;
        long[] b = this.list.get(lineIndex >> 12);
        return new FileOffset(b[lineIndex & 0xFFF]);
    }

    public int size() {
        return this.total_size;
    }

    public static final class FileOffset {
        public final long encodedOffset;

        public FileOffset(long encodedOffset) {
            this.encodedOffset = encodedOffset;
        }

        public int getFileIndex() {
            return (int)(this.encodedOffset & 0xFFL);
        }

        public long getOffsetInFile() {
            return this.encodedOffset >> 8;
        }
    }
}

