/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.PersistentModel;
import com.azul.log.gui.model.ScratchpadModel;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.ScratchpadPanel;
import com.azul.log.gui.utils.jfreechart.PlotSeriesVisibilitySupport;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ScratchpadsSelectionModel
extends AbstractModel
implements PersistentModel {
    private final Map<String, List<ScratchpadEntryInfo>> scratchpads = new HashMap<String, List<ScratchpadEntryInfo>>();
    private static final ScratchpadsSelectionModel model = new ScratchpadsSelectionModel();
    private JMenu loadMenu;
    private JMenu removeMenu;

    public static ScratchpadsSelectionModel getModel() {
        return model;
    }

    private ScratchpadsSelectionModel() {
    }

    public void saveScratchpad(ScratchpadPanel scratchpadPanel) {
        String input = JOptionPane.showInputDialog(MainFrame.get(), "Enter a scratchpad name:", "Scratchpads Selection", 1);
        if (input == null || input.isEmpty()) {
            return;
        }
        int n = 1;
        Object temp = input;
        while (this.scratchpads.containsKey(temp)) {
            temp = input + "(" + n + ")";
            ++n;
        }
        input = temp;
        Map<GraphDefinition, Integer> displayedGraphs = ScratchpadModel.getModel().getDisplayedGraphs();
        LinkedList<ScratchpadEntryInfo> newScratchpadSelection = new LinkedList<ScratchpadEntryInfo>();
        for (GraphDefinition gd : displayedGraphs.keySet()) {
            int graphHash = this.getGraphDefinitionHash(gd);
            boolean[] visibilityStatus = PlotSeriesVisibilitySupport.getSeriesVisibilityState(gd.getID());
            newScratchpadSelection.add(new ScratchpadEntryInfo(graphHash, this.visibilityStatusToString(visibilityStatus)));
        }
        this.scratchpads.put(input, newScratchpadSelection);
        this.updateMenuItems(scratchpadPanel);
        this.fireChange();
    }

    private void loadScratchpad(ScratchpadPanel scratchpadPanel, String name) {
        PlotData plotData = Context.lookup(PlotData.class);
        List<GraphDefinition> graphDefinitions = plotData.getGraphDefinitions();
        LinkedList<GraphDefinition> scratchpadsToDisplay = new LinkedList<GraphDefinition>();
        HashMap<Integer, boolean[]> seriesVisibilityStatus = new HashMap<Integer, boolean[]>();
        List<ScratchpadEntryInfo> selectedScratchpad = this.scratchpads.get(name);
        for (ScratchpadEntryInfo entry : selectedScratchpad) {
            GraphDefinition gd = this.getGraphDefinitionByHash(graphDefinitions, entry.graphHash);
            if (gd == null || !gd.hasData()) continue;
            scratchpadsToDisplay.add(gd);
            seriesVisibilityStatus.put(gd.getID(), this.visibilityStatusFromString(entry.seriesVisibility));
        }
        ScratchpadModel.getModel().clear(scratchpadPanel.getMainPlot(), scratchpadPanel.getSliderPlot());
        scratchpadPanel.setDisplayedGraphs(scratchpadsToDisplay, seriesVisibilityStatus, name);
    }

    private void removeScratchpad(ScratchpadPanel scratchpadPanel, String name) {
        this.scratchpads.remove(name);
        this.fireChange();
        this.updateMenuItems(scratchpadPanel);
    }

    public void initMenus(ScratchpadPanel scratchpadPanel, JMenu loadMenu, JMenu removeMenu) {
        this.loadMenu = loadMenu;
        this.removeMenu = removeMenu;
        this.updateMenuItems(scratchpadPanel);
    }

    private void updateMenuItems(ScratchpadPanel scratchpadPanel) {
        this.loadMenu.removeAll();
        this.removeMenu.removeAll();
        for (String key : this.scratchpads.keySet()) {
            this.loadMenu.add(new JMenuItem(new LoadScratchpadAction(scratchpadPanel, key)));
            this.removeMenu.add(new JMenuItem(new RemoveScratchpadAction(scratchpadPanel, key)));
        }
    }

    private GraphDefinition getGraphDefinitionByHash(List<GraphDefinition> graphDefinitions, int graphHash) {
        return graphDefinitions.stream().filter(gd -> this.getGraphDefinitionHash((GraphDefinition)gd) == graphHash).findFirst().orElse(null);
    }

    private int getGraphDefinitionHash(GraphDefinition gd) {
        return (gd.getCategoryName() + gd.getTitle()).hashCode();
    }

    private String visibilityStatusToString(boolean[] visibilityStatus) {
        StringBuilder statusBuilder = new StringBuilder();
        for (boolean v : visibilityStatus) {
            statusBuilder.append(v ? "1" : "0");
        }
        return statusBuilder.toString();
    }

    private boolean[] visibilityStatusFromString(String visibilityStatus) {
        boolean[] visibilityStatusArray = new boolean[visibilityStatus.length()];
        for (int i = 0; i < visibilityStatusArray.length; ++i) {
            visibilityStatusArray[i] = visibilityStatus.charAt(i) == '1';
        }
        return visibilityStatusArray;
    }

    @Override
    public String getPersistentID() {
        return "ScratchpadsSelectionModel";
    }

    @Override
    public void initFromExternalString(String data) {
        this.scratchpads.clear();
        if (data != null && !data.isEmpty()) {
            String[] selections;
            for (String selection : selections = data.split(";")) {
                int separatorIndex = selection.indexOf("#");
                if (separatorIndex == -1) {
                    return;
                }
                int labelLength = Integer.parseInt(selection.substring(0, separatorIndex));
                String label = selection.substring(separatorIndex + 1, separatorIndex + labelLength + 1);
                LinkedList<ScratchpadEntryInfo> graphEntries = new LinkedList<ScratchpadEntryInfo>();
                if (selection.length() > separatorIndex + labelLength + 2) {
                    String graphs = selection.substring(separatorIndex + labelLength + 2);
                    for (String entry : graphs.split(" ")) {
                        if (entry.isEmpty()) continue;
                        String[] splitEntry = entry.split(":");
                        if (splitEntry.length != 2) {
                            throw new InternalError();
                        }
                        int graphHash = (int)Long.parseLong(splitEntry[0], 16);
                        String seriesVisibility = splitEntry[1];
                        graphEntries.add(new ScratchpadEntryInfo(graphHash, seriesVisibility));
                    }
                }
                this.scratchpads.put(label, graphEntries);
            }
        }
    }

    @Override
    public String toExternalString() {
        StringBuilder builder = new StringBuilder();
        for (String key : this.scratchpads.keySet()) {
            builder.append(key.length()).append("#").append(key).append("=");
            this.scratchpads.get(key).forEach(id -> builder.append(Integer.toHexString(id.graphHash)).append(":").append(id.seriesVisibility).append(" "));
            builder.replace(builder.length() - 1, builder.length(), ";");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static class ScratchpadEntryInfo {
        private final int graphHash;
        private final String seriesVisibility;

        private ScratchpadEntryInfo(int graphHash, String seriesVisibility) {
            this.graphHash = graphHash;
            this.seriesVisibility = seriesVisibility;
        }
    }

    private class RemoveScratchpadAction
    extends AbstractAction {
        private final String label;
        private final ScratchpadPanel scratchpadPanel;

        RemoveScratchpadAction(ScratchpadPanel scratchpadPanel, String label) {
            super(label);
            this.label = label;
            this.scratchpadPanel = scratchpadPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScratchpadsSelectionModel.this.removeScratchpad(this.scratchpadPanel, this.label);
        }
    }

    private class LoadScratchpadAction
    extends AbstractAction {
        private final String label;
        private final ScratchpadPanel scratchpadPanel;

        LoadScratchpadAction(ScratchpadPanel scratchpadPanel, String label) {
            super(label);
            this.label = label;
            this.scratchpadPanel = scratchpadPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScratchpadsSelectionModel.this.loadScratchpad(this.scratchpadPanel, this.label);
        }
    }
}

