/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.support;

import com.azul.log.model.api.FieldDescription;
import com.azul.log.model.api.LogRecord;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RecordFieldTooltipSupport {
    private RecordFieldTooltipSupport() {
    }

    public static String getHTMLTooltip(LogRecord record, Field field) {
        return RecordFieldTooltipSupport.getHTMLTooltip(record, field, Collections.emptyList());
    }

    public static String getHTMLTooltip(LogRecord record, Field field, List<String> notes) {
        if (record == null || field == null) {
            return null;
        }
        FieldDescription fd = record.getFieldDescription(field);
        String units = fd.units().getAbbreviation();
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<table class='tooltip'>").append("<tr><td>").append(fd.shortDescription()).append(": ").append(record.getFieldValueAsString(field)).append(" ").append(units).append("</td></tr>");
        String fieldSpec = fd.fieldSpec();
        if (fieldSpec != null) {
            sb.append("<tr style='border-top: 1px solid gray;'><td align='right'><font color='gray'>").append(fieldSpec).append("</font></td></tr>");
        }
        List allNotes = Stream.concat(fd.notes().stream(), notes.stream()).collect(Collectors.toList());
        for (int i = 0; i < allNotes.size(); ++i) {
            sb.append(i == 0 ? "<tr style='border-top: 1px solid gray'>" : "<tr>").append("<td style='font-style: italic; color: gray'>").append((String)allNotes.get(i)).append("</td></tr>");
        }
        sb.append("</table></html>");
        return sb.toString();
    }
}

