/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.tables.api;

import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.tables.api.TablesDefinitionProvider;
import com.azul.log.model.api.LogModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

public final class TableData {
    private final List<TableDefinition> definitions;

    private TableData(LogModel logModel) {
        List tmp = logModel == null ? Collections.emptyList() : Lookup.getDefault().lookupAll(TablesDefinitionProvider.class).stream().map(p -> p.getTablesDefinition(logModel)).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap map = new HashMap();
        tmp.stream().filter(d -> d.hasData() || !map.containsKey(d.getID())).forEach(d -> map.put(d.getID(), d));
        this.definitions = new ArrayList(map.values());
        this.definitions.sort(new ComparatorImpl());
    }

    public static TableData create(LogModel model) {
        return new TableData(model);
    }

    public int getTablesCount() {
        return this.definitions.size();
    }

    public String getTableName(int index) {
        return this.definitions.get(index).getTitle();
    }

    public TableDefinition getTableDefinition(int index) {
        return this.definitions.get(index);
    }

    private static class ComparatorImpl
    implements Comparator<TableDefinition>,
    Serializable {
        private ComparatorImpl() {
        }

        @Override
        public int compare(TableDefinition o1, TableDefinition o2) {
            int graphPositionDelta = o1.getPosition() - o2.getPosition();
            if (graphPositionDelta != 0) {
                return graphPositionDelta;
            }
            return o1.getTitle().compareTo(o2.getTitle());
        }
    }
}

