/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.tables.api;

import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.tables.api.annotations.TableDescription;
import com.azul.log.gui.tables.api.annotations.TablesDescription;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class TablesDefinitionProvider {
    public Collection<? extends TableDefinition> getTablesDefinition(LogModel logModel) {
        LinkedList<TableDefinition> result = new LinkedList<TableDefinition>();
        for (Annotation descriptions : this.getClass().getAnnotations()) {
            if (!(descriptions instanceof TablesDescription)) continue;
            result.addAll(this.createDefinitions(logModel, (TablesDescription)descriptions));
        }
        return result;
    }

    private List<TableDefinition> createDefinitions(LogModel logModel, TablesDescription description) {
        return description.model().equals(logModel.getModelID()) ? Arrays.stream(description.tables()).map(d -> this.createDefinition(logModel, (TableDescription)d)).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
    }

    private TableDefinition createDefinition(LogModel logModel, TableDescription descr) {
        try {
            Class<? extends LogRecord> klass = descr.source();
            String filterMethodName = descr.filter();
            Method filterMethod = filterMethodName.isEmpty() ? null : klass.getMethod(filterMethodName, new Class[0]);
            LogRecordsList data = logModel.getRecordsMap().getRecords(klass, null, null, filterMethod, null);
            return new TableDefinition(logModel, descr, data);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            Logger.getLogger(TablesDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

