/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.ui.TimeZonePicker;
import com.azul.log.model.api.LogTimeModel;
import java.awt.event.ActionEvent;
import java.time.ZoneId;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DisplayTimeUnitsSelector
extends JMenu {
    private final Lookup.Result<LogTimeModel> result = Context.lookupResult(LogTimeModel.class);

    public DisplayTimeUnitsSelector() {
        super("Time Units");
        LookupListenerImpl listener = new LookupListenerImpl();
        this.result.addLookupListener(listener);
        listener.resultChanged(null);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        @Override
        public void resultChanged(LookupEvent le) {
            DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
            DisplayTimeUnitsSelector.this.removeAll();
            if (dtm == null) {
                return;
            }
            ButtonGroup group = new ButtonGroup();
            LogTimeModel timeModel = Context.lookup(LogTimeModel.class);
            boolean enabled = timeModel != null;
            this.addUnitAction(DisplayTimeModel.Units.AUTO, dtm, group, enabled);
            this.addUnitAction(DisplayTimeModel.Units.HOURS, dtm, group, enabled);
            this.addUnitAction(DisplayTimeModel.Units.MINUTES, dtm, group, enabled);
            this.addUnitAction(DisplayTimeModel.Units.SECONDS, dtm, group, enabled);
            enabled = enabled && timeModel.getAbsoluteTimestampBase() != null;
            DisplayTimeUnitsSelector.this.add(new JPopupMenu.Separator());
            this.addAbsoluteTimeAction(DisplayTimeModel.TZone.FILE, dtm, group, enabled && timeModel.getTimeZoneId() != null);
            this.addAbsoluteTimeAction(DisplayTimeModel.TZone.UTC, dtm, group, enabled);
            this.addAbsoluteTimeAction(DisplayTimeModel.TZone.SYSTEM, dtm, group, enabled);
            DisplayTimeUnitsSelector.this.add(new JPopupMenu.Separator());
            this.addAbsoluteTimeAction(DisplayTimeModel.TZone.USER, dtm, group, enabled);
            this.addSetUserTimeZoneAction(dtm, enabled);
        }

        private void addUnitAction(final DisplayTimeModel.Units units, final DisplayTimeModel dtm, ButtonGroup group, boolean enabled) {
            AbstractAction a = new AbstractAction(units.getDescription()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dtm.setUnits(units);
                }
            };
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(a);
            item.setEnabled(enabled);
            item.setSelected(units == dtm.getUnits());
            group.add(item);
            DisplayTimeUnitsSelector.this.add(item);
        }

        private void addAbsoluteTimeAction(final DisplayTimeModel.TZone tzone, final DisplayTimeModel dtm, ButtonGroup group, boolean enabled) {
            AbstractAction a = new AbstractAction(tzone.getDescription()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dtm.setUnits(DisplayTimeModel.Units.ABSOLUTE);
                    dtm.setTZone(tzone);
                }
            };
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(a);
            item.setEnabled(enabled);
            item.setSelected(dtm.getUnits() == DisplayTimeModel.Units.ABSOLUTE && dtm.getTZone() == tzone);
            group.add(item);
            DisplayTimeUnitsSelector.this.add(item);
        }

        private void addSetUserTimeZoneAction(final DisplayTimeModel dtm, boolean enabled) {
            AbstractAction a = new AbstractAction("Select User Time Zone ..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ZoneId zoneId = TimeZonePicker.selectZoneId();
                    if (zoneId != null) {
                        dtm.setUnits(DisplayTimeModel.Units.ABSOLUTE);
                        dtm.setTZone(DisplayTimeModel.TZone.USER);
                        dtm.setUserZoneId(zoneId);
                        LookupListenerImpl.this.resultChanged(null);
                    }
                }
            };
            JMenuItem item = new JMenuItem(a);
            item.setEnabled(enabled);
            DisplayTimeUnitsSelector.this.add(item);
        }
    }
}

