/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.ItemSelectionActions;
import com.azul.log.gui.markup.api.HTMLMarkup;
import com.azul.log.gui.markup.impl.TextHighlightProvider;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.LogRecordElement;
import com.azul.log.gui.model.SelectionController;
import com.azul.log.gui.model.TextSearchContext;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.spi.LogContentProvider;
import com.azul.log.gui.search.LogTextSearchTask;
import com.azul.log.gui.search.TableFilterer;
import com.azul.log.gui.support.RecordFieldTooltipSupport;
import com.azul.log.gui.ui.RangeSlider;
import com.azul.log.gui.ui.TableViewBase;
import com.azul.log.gui.ui.TextSearchPanel;
import com.azul.log.gui.ui.ViewsNavigationPanel;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.model.spi.LogLineWithTimeProvider;
import com.azul.log.model.spi.LogRecordFieldsProvider;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.EventObject;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleText;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.View;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class LogView
extends TableViewBase {
    private static final String NEXT_PARAGRAPH = "nextParagraph";
    private static final String PREV_PARAGRAPH = "prevParagraph";
    private static final String JUMP_TO_MATCHING_BRACKET = "jumpToMatchingBracket";
    private final Lookup lookup;
    private final int preferredTableWidth;
    private final TextSearchPanel searchPanel;
    private final RangeSlider rangeSlider;
    private final LogContentProvider logContentProvider;
    private final LogModel logModel;
    private final LogLineWithTimeProvider logLineWithTimeProvider;
    private final TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeRangeModel;
    private final TableFilterer<TableModel> tableFilterer;
    private final ChangeListener searchChangeListener;
    private final Runnable tableUpdateAction;
    private String selectedText;
    private SearchFilterTask searchFilterTask;

    public LogView(LogModel logModel) {
        super(new LogDataTableModel(logModel.lookup(LogContentProvider.class)), new ConverterImpl(), logModel);
        this.logModel = logModel;
        this.logContentProvider = logModel.lookup(LogContentProvider.class);
        this.logLineWithTimeProvider = Context.lookup(LogLineWithTimeProvider.class);
        this.visibleTimeRangeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        this.rangeSlider = new RangeSlider((BoundedRangeModel)((Object)this.visibleTimeRangeModel));
        CellRenderer renderer = new CellRenderer();
        CellEditor editor = new CellEditor();
        this.table.getTableHeader().setUI(null);
        this.table.setBackground(Color.white);
        this.table.setDefaultRenderer(String.class, renderer);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultEditor(String.class, editor);
        this.rangeSlider.setVisible(false);
        TextSearchContextImpl searchContext = new TextSearchContextImpl();
        ActionListener listener = e -> {
            if (this.isLogViewFiltered()) {
                return;
            }
            String cmd = e.getActionCommand();
            if (cmd != null) {
                switch (cmd) {
                    case "nextParagraph": {
                        this.jumpToParagraph(1);
                        break;
                    }
                    case "prevParagraph": {
                        this.jumpToParagraph(0);
                        break;
                    }
                    case "jumpToMatchingBracket": {
                        this.jumpToMatchingBracket();
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        };
        this.table.registerKeyboardAction(listener, NEXT_PARAGRAPH, KeyStroke.getKeyStroke(39, 0), 1);
        this.table.registerKeyboardAction(listener, PREV_PARAGRAPH, KeyStroke.getKeyStroke(37, 0), 1);
        this.table.registerKeyboardAction(listener, JUMP_TO_MATCHING_BRACKET, KeyStroke.getKeyStroke(53, 64), 1);
        this.table.registerKeyboardAction(ItemSelectionActions.NEXT, ItemSelectionActions.getKeystroke(ItemSelectionActions.NEXT), 1);
        this.table.registerKeyboardAction(ItemSelectionActions.PREVIOUS, ItemSelectionActions.getKeystroke(ItemSelectionActions.PREVIOUS), 1);
        int maxWidth = 0;
        if (this.logContentProvider != null && this.table.getColumnModel().getColumnCount() > 0) {
            int widestLineNumber = this.logContentProvider.getWidestLineNumber();
            int tabsAdjustment = 0;
            if (widestLineNumber > 0) {
                CharSequence line = this.logContentProvider.getLine(widestLineNumber);
                tabsAdjustment = 35 * (int)line.chars().filter(s -> s == 9).count();
            }
            TableColumn column0 = this.table.getColumnModel().getColumn(0);
            CellRenderer c = (CellRenderer)this.table.prepareRenderer(renderer, widestLineNumber - 1, 0);
            maxWidth = c.getPreferredSize().width + this.table.getIntercellSpacing().width + tabsAdjustment;
            column0.setPreferredWidth(maxWidth);
        }
        this.preferredTableWidth = maxWidth;
        this.searchPanel = new TextSearchPanel(this.table);
        this.searchPanel.setVisible(false);
        TextHighlightProvider.reset();
        this.tableUpdateAction = () -> {
            this.table.revalidate();
            this.table.repaint();
            this.updateRowHeader();
        };
        this.tableFilterer = new TableFilterer<TableModel>(this.table.getModel(), this.searchPanel, this.tableUpdateAction);
        this.searchChangeListener = e -> {
            this.rangeSlider.setVisible(this.searchPanel.applyFiltering());
            if (this.searchFilterTask != null) {
                this.searchFilterTask.cancel();
            }
            boolean isSearchTextAvailable = this.searchPanel.getCompositeSearchBar().isSearchTextAvailable();
            if (!this.searchPanel.isVisible()) {
                TextHighlightProvider.reset();
                this.rangeSlider.setVisible(false);
                if (this.isLogViewFiltered()) {
                    this.table.setRowSorter(null);
                } else {
                    this.tableUpdateAction.run();
                }
                return;
            }
            if (this.searchPanel.applyFiltering() && (isSearchTextAvailable || !this.visibleTimeRangeModel.isWholeRange())) {
                this.table.setRowSorter(this.tableFilterer);
                this.searchFilterTask = new SearchFilterTask();
            } else {
                this.table.setRowSorter(null);
            }
            if (isSearchTextAvailable) {
                TextHighlightProvider.setContext(this.searchPanel.getSearchContext(), this.searchPanel.isCaseSensitive());
            } else {
                TextHighlightProvider.reset();
            }
            this.tableUpdateAction.run();
        };
        this.add((Component)this.searchPanel, "South");
        this.lookup = Lookups.fixed(searchContext, new SelectionControllerImpl());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                ViewsNavigationPanel.processNavigationMouseListener(event);
                super.mouseClicked(event);
            }
        });
    }

    public RangeSlider getRangeSlider() {
        return this.rangeSlider;
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public LogModel getLogModel() {
        return this.logModel;
    }

    @Override
    public LogRecord getRecordAtRow(int row) {
        return this.logModel.getRecordsMap().getRecordAtLine(row + 1);
    }

    @Override
    protected int getRowFor(UIElement selection) {
        return selection.getLogLineNumber() - 1;
    }

    @Override
    protected void installListeners() {
        this.searchPanel.addChangeListener(this.searchChangeListener);
        this.visibleTimeRangeModel.addChangeListener(this.searchChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.searchPanel.removeChangeListener(this.searchChangeListener);
        this.visibleTimeRangeModel.removeChangeListener(this.searchChangeListener);
    }

    private void jumpToMatchingBracket() {
        int line = this.table.getSelectedRow() + 1;
        this.selectFileLine(this.findMatchingBracket(line));
    }

    private void jumpToParagraph(int direction) {
        int line = this.table.getSelectedRow() + direction;
        if (line > 0) {
            int balance = this.getBracketsBalance(line);
            if (balance == 0 || balance > 0 && direction == 0 || balance < 0 && direction == 1) {
                this.selectFileLine(line + direction);
            } else {
                this.selectFileLine(this.findMatchingBracket(line) + direction);
            }
        }
    }

    private int findMatchingBracket(int startLine) {
        int horizon;
        int increment;
        assert (this.logContentProvider != null);
        int line = startLine;
        int balance = this.getBracketsBalance(line);
        int n = increment = balance > 0 ? 1 : -1;
        for (horizon = 100; horizon > 0 && balance != 0; --horizon, balance += this.getBracketsBalance(line)) {
            if ((line += increment) <= 0 || line > this.logContentProvider.getLinesCount()) break;
        }
        return horizon == 0 ? startLine : line;
    }

    private int getBracketsBalance(int lineNumber) {
        assert (this.logContentProvider != null);
        int balance = 0;
        CharSequence text = this.logContentProvider.getLine(lineNumber);
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '[') {
                    ++balance;
                    continue;
                }
                if (c != ']') continue;
                --balance;
            }
        }
        return balance;
    }

    private void selectFileLine(int line) {
        assert (this.logContentProvider != null);
        if (line > 0 && line <= this.logContentProvider.getLinesCount()) {
            int row = line - 1;
            this.table.getSelectionModel().setSelectionInterval(row, row);
            this.ensureRowIsVisible(row);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.table.requestFocusInWindow();
    }

    @Override
    protected RelativeTimestamp getRelativeTimestampForRow(int row) {
        return TimeAdjustmentSupport.withLogModel(this.logModel, () -> {
            LogRecord record = this.getRecordAtRow(row);
            if (record != null) {
                return record.getEventRelativeTimestamp();
            }
            for (int lineNumber = row + 1; lineNumber > 0; --lineNumber) {
                CharSequence line = this.logContentProvider.getLine(lineNumber);
                RelativeTimestamp ts = this.extractRelativeTimestamp(line);
                if (ts == null) continue;
                return ts;
            }
            int rows = this.table.getRowCount();
            int limit = Math.min(row + 50, rows);
            for (int lineNumber = row + 2; lineNumber < limit; ++lineNumber) {
                CharSequence line = this.logContentProvider.getLine(lineNumber);
                RelativeTimestamp ts = this.extractRelativeTimestamp(line);
                if (ts == null) continue;
                return ts;
            }
            return null;
        });
    }

    private RelativeTimestamp extractRelativeTimestamp(CharSequence line) throws ParserException {
        LogLineWithTime logLineWithTime = this.logLineWithTimeProvider == null ? null : this.logLineWithTimeProvider.parse(line);
        return logLineWithTime == null ? RelativeTimestamp.of(0.0, TimeUnit.NANOSECONDS) : logLineWithTime.getRelativeTimestamp();
    }

    private class TextSearchContextImpl
    implements TextSearchContext {
        private LogTextSearchTask currentTask;

        private TextSearchContextImpl() {
        }

        @Override
        public void cancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
        }

        @Override
        public void find() {
            this.cancelEditor();
            if (LogView.this.selectedText != null && !LogView.this.selectedText.isEmpty()) {
                LogView.this.searchPanel.setSearchText(LogView.this.selectedText);
            }
            LogView.this.searchPanel.setVisible(true);
        }

        @Override
        public void findNext() {
            this.search(LogTextSearchTask.SearchDirection.FORWARD);
        }

        @Override
        public void findPrevious() {
            this.search(LogTextSearchTask.SearchDirection.BACKWARD);
        }

        private void search(LogTextSearchTask.SearchDirection direction) {
            boolean isSearchTextAvailable;
            this.cancelEditor();
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
            if (!(isSearchTextAvailable = LogView.this.searchPanel.getCompositeSearchBar().isSearchTextAvailable())) {
                this.find();
                return;
            }
            if (!LogView.this.isLogViewFiltered()) {
                this.currentTask = LogTextSearchTask.submit(LogView.this.logContentProvider, LogView.this.table.getSelectedRow() + 1, direction, LogView.this.searchPanel, x$0 -> LogView.this.selectFileLine(x$0));
            }
        }

        private void cancelEditor() {
            TableCellEditor editor = LogView.this.table.getCellEditor();
            if (editor != null) {
                editor.cancelCellEditing();
            }
        }
    }

    private final class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final HTMLMarkup markup = new HTMLMarkup();
        private final Action selectWordAction;
        private final JTextPane editorComp = new JTextPane(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(LogView.this.table.getSelectionBackground());
                Rectangle r = g.getClipBounds();
                g.drawRect(0, 0, this.getWidth(), r.height - 1);
            }
        };
        private MouseEvent activationMouseEvent;

        public CellEditor() {
            this.editorComp.setContentType("text/html");
            this.editorComp.setEditable(false);
            this.editorComp.setBorder(new EmptyBorder(-5, 5, 0, 0));
            this.editorComp.addCaretListener(e -> {
                LogView.this.selectedText = this.editorComp.getSelectedText();
            });
            this.selectWordAction = this.editorComp.getActionMap().get("select-word");
            KeyStroke copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
            InputMap im = this.editorComp.getInputMap(0);
            im.put(copy, "copy-to-clipboard");
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (super.isCellEditable(e) && e instanceof MouseEvent) {
                this.activationMouseEvent = (MouseEvent)e;
                return this.activationMouseEvent.getClickCount() >= 2;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorComp.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            HTMLMarkup.FormattedHTML ht = this.markup.highlight((Object)LogView.this.getRecordAtRow(row), String.valueOf(value), isSelected);
            this.editorComp.setText(HTMLMarkup.decorate(ht.html));
            MouseEvent me = this.activationMouseEvent;
            if (me != null) {
                SwingUtilities.invokeLater(() -> this.selectWordAction.actionPerformed(new ActionEvent(this.editorComp, 1001, null, me.getWhen(), me.getModifiersEx())));
            }
            return this.editorComp;
        }
    }

    private final class CellRenderer
    extends DefaultTableCellRenderer {
        private final HTMLMarkup markup = new HTMLMarkup();
        private final LogRecordFieldsProvider provider = Context.lookup(LogRecordFieldsProvider.class);
        private int rowIndex = -1;

        @Override
        public String getToolTipText(MouseEvent event) {
            if (this.provider == null) {
                return null;
            }
            LogRecord record = LogView.this.getRecordAtRow(LogView.this.table.convertRowIndexToModel(this.rowIndex));
            if (record == null) {
                return null;
            }
            AccessibleText accessibleText = this.getAccessibleContext().getAccessibleText();
            View textView = (View)this.getClientProperty("html");
            if (accessibleText != null && textView != null) {
                Point point = event.getPoint();
                point.translate(-this.getInsets().left, -this.getInsets().top);
                try {
                    Document doc = textView.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    int char_index = accessibleText.getIndexAtPoint(point);
                    Field field = this.provider.getFieldAtChar(record.getClass(), text, char_index);
                    return RecordFieldTooltipSupport.getHTMLTooltip(record, field);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(LogView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return null;
        }

        @Override
        public int getWidth() {
            return LogView.this.preferredTableWidth;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.rowIndex = row;
            HTMLMarkup.FormattedHTML ht = this.markup.highlight((Object)LogView.this.getRecordAtRow(row), String.valueOf(value), isSelected);
            this.setBackground(ht.highlight == null || LogView.this.isLogViewFiltered() ? table.getBackground() : ht.highlight);
            return super.getTableCellRendererComponent(table, HTMLMarkup.decorate(ht.html), isSelected, hasFocus, row, column);
        }
    }

    private static class SelectionControllerImpl
    extends SelectionController<RecordElement> {
        private SelectionControllerImpl() {
            super(RecordElement.class);
        }

        @Override
        public RecordElement getNext(RecordElement element) {
            LogContentProvider logContentProvider = Context.lookup(LogContentProvider.class);
            LogModel logModel = Context.lookup(LogModel.class);
            if (logModel != null && logContentProvider != null) {
                return TimeAdjustmentSupport.withLogModel(logModel, () -> {
                    for (int i = element.row + 1; i < logContentProvider.getLinesCount(); ++i) {
                        LogRecord record = logModel.getRecordsMap().getRecordAtLine(i + 1);
                        if (record == null || !element.getLogRecord().getClass().equals(record.getClass())) continue;
                        return new RecordElement(i, record, logModel);
                    }
                    return null;
                });
            }
            return null;
        }

        @Override
        public RecordElement getPrevious(RecordElement element) {
            LogModel logModel = Context.lookup(LogModel.class);
            if (logModel != null) {
                return TimeAdjustmentSupport.withLogModel(logModel, () -> {
                    for (int i = element.row - 1; i >= 0; --i) {
                        LogRecord record = logModel.getRecordsMap().getRecordAtLine(i + 1);
                        if (record == null || !element.getLogRecord().getClass().equals(record.getClass())) continue;
                        return new RecordElement(i, record, logModel);
                    }
                    return null;
                });
            }
            return null;
        }
    }

    private static class RecordElement
    extends LogRecordElement {
        private final int row;

        public RecordElement(int row, LogRecord record, LogModel logModel) {
            super(record, logModel);
            this.row = row;
        }
    }

    private static class ConverterImpl
    implements TableViewBase.TableRowToInfoConvertor {
        private ConverterImpl() {
        }

        @Override
        public UIElement getElementAtRow(TableViewBase view, int row) {
            int line = row + 1;
            LogModel logModel = ((LogView)view).getLogModel();
            return TimeAdjustmentSupport.withLogModel(logModel, () -> {
                LogRecord record = logModel.getRecordsMap().getRecordAtLine(line);
                return record == null ? new UIElement(view.getRelativeTimestampForRow(row), line, logModel) : new RecordElement(row, record, logModel);
            });
        }
    }

    public static final class LogDataTableModel
    extends AbstractTableModel {
        private final LogContentProvider logContentProvider;

        private LogDataTableModel(LogContentProvider logContentProvider) {
            this.logContentProvider = logContentProvider;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public int getRowCount() {
            return this.logContentProvider == null ? 0 : this.logContentProvider.getLinesCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.logContentProvider == null || columnIndex != 0) {
                return null;
            }
            CharSequence line = this.logContentProvider.getLine(rowIndex + 1, cs -> this.fireTableCellUpdated(rowIndex, 0));
            return line == null ? "Loading ... " : line;
        }
    }

    private final class SearchFilterTask {
        private final SearchWorker worker = new SearchWorker();

        private SearchFilterTask() {
            LogView.this.searchPanel.startProgress(LogView.this.logContentProvider.getLinesCount());
            this.worker.execute();
        }

        public void cancel() {
            LogView.this.searchPanel.stopProgress();
            this.worker.cancel(true);
            LogView.this.tableFilterer.reset();
        }

        private final class SearchWorker
        extends SwingWorker<Void, Void> {
            private SearchWorker() {
            }

            @Override
            protected Void doInBackground() {
                if (!this.isCancelled()) {
                    LogView.this.tableFilterer.filter();
                }
                return null;
            }

            @Override
            protected void done() {
                LogView.this.searchPanel.stopProgress();
                if (!this.isCancelled()) {
                    LogView.this.tableUpdateAction.run();
                }
            }
        }
    }
}

