/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.OpenFileAction;
import com.azul.log.gui.model.RecentOpenFilesModel;
import com.azul.log.gui.support.OpenFileSupport;
import com.azul.log.gui.ui.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public final class RecentFilesSelector
extends JMenu {
    private static final String CMD_UPDATE = "update";
    private final AbstractAction action;

    public RecentFilesSelector(final OpenFileSupport.LogFilesOpenHandler openLogHandler) {
        super("Open Recent Files");
        this.action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipManager ttm = ToolTipManager.sharedInstance();
                ttm.setEnabled(false);
                ttm.setEnabled(true);
                new OpenFileAction(Collections.singletonList(new File(e.getActionCommand()).toURI()), openLogHandler).actionPerformed(e);
            }
        };
        this.getActionMap().put(CMD_UPDATE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesSelector.this.updateItems((e.getModifiers() & 1) > 0);
            }
        });
        InputMap im = this.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(16, 64), CMD_UPDATE);
        im.put(KeyStroke.getKeyStroke(16, 0, true), CMD_UPDATE);
        this.updateItems(false);
        RecentOpenFilesModel.getModel().addChangeListener(e -> this.updateItems(false));
    }

    private void updateItems(boolean fullPath) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateItemsImpl(fullPath);
        } else {
            SwingUtilities.invokeLater(() -> this.updateItemsImpl(fullPath));
        }
    }

    private void updateItemsImpl(boolean fullPath) {
        this.removeAll();
        JMenuItem hint = new JMenuItem("Hint: Press '" + KeyEvent.getKeyText(KeyStroke.getKeyStroke(16, 0).getKeyCode()) + "' to see full paths");
        hint.setEnabled(false);
        this.add(hint);
        this.add(new JPopupMenu.Separator());
        final List<String> recentFiles = RecentOpenFilesModel.getModel().getFiles();
        recentFiles.forEach(recentFile -> {
            JMenuItem item = new JMenuItem();
            item.setAction(this.action);
            item.setActionCommand((String)recentFile);
            if (fullPath) {
                item.setText((String)recentFile);
            } else {
                item.setText(new File((String)recentFile).getName());
                item.setToolTipText((String)recentFile);
            }
            this.add(item);
        });
        this.add(new JPopupMenu.Separator());
        JMenuItem clear = new JMenuItem();
        clear.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(MainFrame.get(), "Are you sure you want to clear the Open Recent File menu?", "Clear Recent Files List", 0, 3);
                if (answer == 0) {
                    RecentOpenFilesModel.getModel().setFiles(Collections.emptyList());
                }
            }

            @Override
            public boolean isEnabled() {
                return !recentFiles.isEmpty();
            }
        });
        clear.setText("Clear Recent Files List ...");
        clear.setToolTipText("Clear Recent Files List ...");
        this.add(clear);
        JPopupMenu m = this.getPopupMenu();
        m.setPopupSize(m.getLayout().preferredLayoutSize(m));
    }
}

