/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.spi.VersionProvider;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.PlotSeriesVisibilityModel;
import com.azul.log.gui.model.ScratchpadModel;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.ui.ContentPanel;
import com.azul.log.gui.ui.RangeSlider;
import com.azul.log.gui.utils.jfreechart.JFreeChartSupport;
import com.azul.log.gui.utils.jfreechart.PlotEx;
import com.azul.log.gui.utils.jfreechart.PlotSeriesVisibilitySupport;
import com.azul.log.gui.utils.jfreechart.ScratchpadChartPanelEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;
import org.openide.util.Lookup;

public class ScratchpadPanel
extends ContentPanel {
    private final PlotEx mainScratchpadPlot;
    private final PlotEx sliderScratchpadPlot;
    private final JFreeChart sliderScratchpadChart;
    private final JPanel bottomPanel;
    private TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeRangeModel;
    private final Lookup.Result<TimeRangeSelectionModel.VisibleTimeRangeModel> visibleTimeRangeModelResult;
    private final ChangeListener timeSelectionListener = new TimeSelectionListener();
    private final Lookup.Result<MarksModel> marksModelResult;
    private MarksModel marksModel;
    private boolean visibleRangeChangedBySelf = false;
    private String lastSelectedScratchpadName;

    public ScratchpadPanel() {
        super(Lookup.EMPTY);
        this.setLayout(new BorderLayout());
        this.visibleTimeRangeModelResult = Context.lookupResult(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        this.visibleTimeRangeModelResult.addLookupListener(e -> {
            this.visibleTimeRangeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
            if (this.visibleTimeRangeModel != null) {
                this.visibleTimeRangeModel.removeChangeListener(this.timeSelectionListener);
                this.visibleTimeRangeModel.addChangeListener(this.timeSelectionListener);
            }
        });
        this.marksModelResult = Context.lookupResult(MarksModel.class);
        this.marksModelResult.addLookupListener(e -> {
            if (this.marksModel != null) {
                this.ic.remove(this.marksModel.getCategoriesModel());
            }
            this.marksModel = Context.lookup(MarksModel.class);
            this.ic.add(this.marksModel.getCategoriesModel());
        });
        this.sliderScratchpadPlot = new PlotEx(true);
        this.sliderScratchpadChart = new JFreeChart("Scratchpad", JFreeChart.DEFAULT_TITLE_FONT, this.sliderScratchpadPlot, false);
        this.mainScratchpadPlot = new PlotEx(false);
        JFreeChart mainScratchpadChart = new JFreeChart("Scratchpad", JFreeChart.DEFAULT_TITLE_FONT, this.mainScratchpadPlot, true);
        mainScratchpadChart.setBackgroundPaint(Color.WHITE);
        ScratchpadChartPanelEx mainChartPanel = new ScratchpadChartPanelEx(mainScratchpadChart);
        mainChartPanel.setUpPopupMenu(this, new ClearChartAction("Clear Scratchpad"));
        mainChartPanel.setBackground(Color.WHITE);
        this.add((Component)mainChartPanel, "Center");
        this.ic.add(mainChartPanel::doSaveAs);
        this.ic.add(mainChartPanel::copyToClipboard);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.setBackground(Color.WHITE);
        this.add((Component)this.bottomPanel, "South");
    }

    public void handleSelection(GraphDefinition gd) {
        if (ScratchpadModel.getModel().isDisplayed(gd)) {
            this.deleteFromScratchpad(gd);
        } else {
            this.addToScratchPad(gd);
        }
        this.updateBottomPanel();
        this.updateSeriesVisibility();
    }

    public void setDisplayedGraphs(List<GraphDefinition> graphDefinitions, Map<Integer, boolean[]> seriesVisibilityStatuses, String scratchpadName) {
        seriesVisibilityStatuses.forEach(PlotSeriesVisibilitySupport::setSeriesVisibilityState);
        graphDefinitions.forEach(this::addToScratchPad);
        this.lastSelectedScratchpadName = scratchpadName;
        this.updateBottomPanel();
        this.updateSeriesVisibility();
    }

    public PlotEx getMainPlot() {
        return this.mainScratchpadPlot;
    }

    public PlotEx getSliderPlot() {
        return this.sliderScratchpadPlot;
    }

    public void resetZoom() {
        this.mainScratchpadPlot.getRangeAxis().setAutoRange(true);
        this.mainScratchpadPlot.getDomainAxis().setAutoRange(true);
        this.lastSelectedScratchpadName = null;
    }

    private void addToScratchPad(GraphDefinition gd) {
        TimeSeries[] ts = JFreeChartSupport.initTimeSeries(gd);
        int datasetPosition = ScratchpadModel.getModel().add(gd);
        JFreeChartSupport.addXYGraphToScratchpad(gd, ts, this.mainScratchpadPlot, this.sliderScratchpadPlot, datasetPosition);
        this.mainScratchpadPlot.getDomainAxis().addChangeListener(new GraphListener());
        this.mainScratchpadPlot.getRangeAxis().setRange(0.0, 100.0);
    }

    private void deleteFromScratchpad(GraphDefinition gd) {
        int freedIndex = ScratchpadModel.getModel().remove(gd);
        this.mainScratchpadPlot.setDataset(freedIndex, null);
        this.mainScratchpadPlot.setRenderer(freedIndex, null);
        this.sliderScratchpadPlot.setDataset(freedIndex, null);
        this.sliderScratchpadPlot.setRenderer(freedIndex, null);
    }

    private void updateBottomPanel() {
        if (this.visibleTimeRangeModel == null) {
            return;
        }
        String versionStr = Lookup.getDefault().lookupAll(VersionProvider.class).stream().map(VersionProvider::getVersion).collect(Collectors.joining("\n"));
        JPanel versionPanel = this.getVersionPanel(versionStr);
        RangeSlider rangeSlider = new RangeSlider(this.sliderScratchpadChart, (BoundedRangeModel)((Object)this.visibleTimeRangeModel));
        this.bottomPanel.removeAll();
        this.bottomPanel.add(versionPanel);
        this.bottomPanel.add(rangeSlider);
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
    }

    private JPanel getVersionPanel(String versionStr) {
        JPanel versionPanel = new JPanel(new BorderLayout());
        JLabel versionLabel = new JLabel(versionStr);
        versionLabel.setForeground(Color.GRAY);
        versionPanel.add((Component)versionLabel, "East");
        String selectedScratchpad = this.lastSelectedScratchpadName == null || this.lastSelectedScratchpadName.isEmpty() ? "" : " " + this.lastSelectedScratchpadName;
        JLabel scratchpadLabel = new JLabel(selectedScratchpad);
        scratchpadLabel.setForeground(Color.GRAY);
        versionPanel.add((Component)scratchpadLabel, "West");
        versionPanel.setBackground(Color.WHITE);
        return versionPanel;
    }

    private void updateSeriesVisibility() {
        PlotSeriesVisibilityModel curr;
        PlotSeriesVisibilityModel prev = this.getLookup().lookup(PlotSeriesVisibilityModel.class);
        if (prev != null) {
            this.ic.remove(prev);
        }
        if ((curr = PlotSeriesVisibilitySupport.createScratchpadSeriesVisibilityModel(this.mainScratchpadPlot, ScratchpadModel.getModel().getDisplayedGraphs())) != null) {
            this.ic.add(curr);
        }
    }

    private class ClearChartAction
    extends AbstractAction {
        public ClearChartAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScratchpadModel.getModel().clear(ScratchpadPanel.this.mainScratchpadPlot, ScratchpadPanel.this.sliderScratchpadPlot);
            ScratchpadPanel.this.updateSeriesVisibility();
            ScratchpadPanel.this.updateBottomPanel();
        }
    }

    private class TimeSelectionListener
    implements ChangeListener {
        private TimeSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ScratchpadPanel.this.visibleRangeChangedBySelf) {
                return;
            }
            TimeRange selection = ScratchpadPanel.this.visibleTimeRangeModel.getSelection();
            if (selection.length(TimeUnit.MILLISECONDS) > 10L) {
                ScratchpadPanel.this.mainScratchpadPlot.getDomainAxis().setRange(JFreeChartSupport.toJFCRange(selection, TimeUnit.NANOSECONDS));
            }
            ScratchpadPanel.this.revalidate();
            ScratchpadPanel.this.repaint();
        }
    }

    private class GraphListener
    implements AxisChangeListener {
        private GraphListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void axisChanged(AxisChangeEvent ace) {
            JFreeChart chart = ScratchpadPanel.this.mainScratchpadPlot.getChart();
            if (chart != null) {
                Range xrange = chart.getXYPlot().getDomainAxis().getRange();
                TimeRange timeRange = JFreeChartSupport.fromJFCRange(xrange, TimeUnit.NANOSECONDS);
                try {
                    ScratchpadPanel.this.visibleRangeChangedBySelf = true;
                    ScratchpadPanel.this.visibleTimeRangeModel.setSelection(timeRange);
                }
                finally {
                    ScratchpadPanel.this.visibleRangeChangedBySelf = false;
                }
            }
        }
    }
}

