/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.tables.api.TableData;
import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.ui.SelectionPanel;
import com.azul.log.gui.ui.nodes.TableNode;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class TableSelectionPanel
extends SelectionPanel<TableNode> {
    private final Lookup.Result<TableData> lookupResult = Context.lookupResult(TableData.class);
    private TableData data = null;

    public TableSelectionPanel() {
        LookupListenerImpl listener = new LookupListenerImpl();
        this.lookupResult.addLookupListener(listener);
        listener.resultChanged(null);
    }

    @Override
    protected TreeNode createRootNode() {
        if (this.data == null) {
            return new DefaultMutableTreeNode();
        }
        int tc = this.data.getTablesCount();
        TableNode[] tables = new TableNode[tc];
        for (int i = 0; i < tc; ++i) {
            TableDefinition td = this.data.getTableDefinition(i);
            tables[i] = new TableNode(this.data.getTableName(i), td);
        }
        return new JTree.DynamicUtilTreeNode((Object)"Tables", tables);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        @Override
        public void resultChanged(LookupEvent le) {
            TableSelectionPanel.this.data = Context.lookup(TableData.class);
            SwingUtilities.invokeLater(TableSelectionPanel.this::updateModel);
        }
    }
}

