/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.Markline;
import com.azul.log.gui.ui.PopupButton;
import com.azul.log.gui.utils.UIUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;

public final class VisibleMarklinesSelector
extends PopupButton {
    private final Lookup.Result<MarksModel.MarksCategoryModel> lookupResult;
    private final ChangeListener modelListener;
    private MarksModel.MarksCategoryModel categoriesModel;

    public VisibleMarklinesSelector() {
        super(UIUtils.loadIcon("/buttons/marklines-show.png"));
        this.setEnabled(false);
        this.setToolTipText("Select Visible Marklines");
        this.lookupResult = Context.lookupResult(MarksModel.MarksCategoryModel.class);
        LookupListener listener = e -> this.registerWithModel();
        this.lookupResult.addLookupListener(listener);
        this.modelListener = e -> this.setEnabled(this.categoriesModel != null && !this.categoriesModel.getAllCategories().isEmpty());
        listener.resultChanged(null);
    }

    private void registerWithModel() {
        if (this.categoriesModel != null) {
            this.categoriesModel.removeChangeListener(this.modelListener);
        }
        this.categoriesModel = Context.lookup(MarksModel.MarksCategoryModel.class);
        if (this.categoriesModel != null) {
            this.categoriesModel.addChangeListener(this.modelListener);
        }
        this.modelListener.stateChanged(null);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        Set<String> allCategories = this.categoriesModel.getAllCategories();
        menu.setLayout(new GridLayout(allCategories.size() + 3, 1));
        allCategories.forEach(c -> menu.add(new ShowMarklinesItem(this.categoriesModel, (String)c)));
        menu.add(new JPopupMenu.Separator());
        menu.add(new ShowAllItem(this.categoriesModel, true));
        menu.add(new ShowAllItem(this.categoriesModel, false));
        return menu;
    }

    private static final class ShowAllItem
    extends PopupButton.CustomJCheckBox {
        private final MarksModel.MarksCategoryModel visibilityModel;

        private ShowAllItem(MarksModel.MarksCategoryModel model, boolean show) {
            super((show ? "Show" : "Hide") + " All Marklines", true);
            this.visibilityModel = model;
            this.initListeners(show);
        }

        private void initListeners(boolean show) {
            this.addActionListener(e -> {
                for (Component c : this.getParent().getComponents()) {
                    if (!(c instanceof ShowMarklinesItem)) continue;
                    ((ShowMarklinesItem)c).setSelected(show);
                }
                this.visibilityModel.setAllVisible(show);
            });
        }
    }

    private static final class ShowMarklinesItem
    extends PopupButton.PopupMenuItem {
        private final MarksModel.MarksCategoryModel categoriesModel;
        private final String category;

        private ShowMarklinesItem(MarksModel.MarksCategoryModel categoriesModel, String category) {
            super(ShowMarklinesItem.getLabel(category), categoriesModel.isVisible(category), Markline.AttributesProvider.getLineColor(category));
            this.categoriesModel = categoriesModel;
            this.category = category;
            this.setEnabled(true);
        }

        private static String getLabel(String category) {
            return category;
        }

        @Override
        protected void performItemAction() {
            UIElementSelectionModel selectionModel;
            UIElement selection;
            boolean selected = this.isSelected();
            this.categoriesModel.setVisible(this.category, selected);
            if (!selected && (selection = (selectionModel = UIElementSelectionModel.getInstance()).getSelectedElement()) instanceof Mark && ((Mark)selection).getCategory().equals(this.category)) {
                selectionModel.clearSelection();
            }
        }
    }
}

