/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.gui.utils.jfreechart.PlotSeriesVisibilitySupport;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.XYItemEntity;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class ChartEx
implements Lookup.Provider {
    private final JFreeChart chart;
    private final GraphDefinition graphDefinition;
    private final boolean isMainChart;
    private final Lookup lookup;

    public ChartEx(GraphDefinition graphDefinition, JFreeChart chart, boolean isMainChart) {
        this.lookup = Lookups.fixed(PlotSeriesVisibilitySupport.createChartSeriesVisibilityModel(graphDefinition, chart), Context.lookup(MarksModel.class).getCategoriesModel(), chart);
        this.chart = chart;
        this.graphDefinition = graphDefinition;
        this.isMainChart = isMainChart;
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public boolean isMainChart() {
        return this.isMainChart;
    }

    public GraphDefinition getGraphDefinition() {
        return this.graphDefinition;
    }

    public void setTitle(String string) {
        this.chart.setTitle(string);
    }

    public void setDomainAxisLabel(String label) {
        this.chart.getXYPlot().getDomainAxis().setLabel(label);
    }

    public void setRangeAxisLabel(String label) {
        this.chart.getXYPlot().getRangeAxis().setLabel(label);
    }

    public JFreeChartRecordElement createInfoElementFor(XYItemEntity e) {
        int seriesIndex = e.getSeriesIndex();
        int itemIndex = e.getItem();
        int itemCount = e.getDataset().getItemCount(seriesIndex);
        return JFreeChartRecordElement.create(this.graphDefinition, seriesIndex, itemIndex, itemCount);
    }
}

