/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.ui.ViewsNavigationPanel;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.BaseChartPanelEx;
import com.azul.log.gui.utils.jfreechart.ChartEx;
import com.azul.log.gui.utils.jfreechart.FavoriteToggleButton;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.gui.utils.jfreechart.NumberAxisEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Optional;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.title.TextTitle;
import org.openide.util.Lookup;

public final class ChartPanelEx
extends BaseChartPanelEx
implements Lookup.Provider {
    private final ChartEx chart;
    private final BaseChartPanelEx.ChangeListenerImpl changeListener;
    private final MarksModel.MarksCategoryModel logMarklinesVisibilityModel;
    private final MarksModel marksModel;
    private final Lookup lookup = Lookup.EMPTY;
    private final boolean isMainPanel;
    private final DisplayTimeModel displayTimeModel;
    private final ChangeListener displayTimeModelListener;

    public ChartPanelEx(ChartEx chart, boolean mouseZoomable, boolean mainPanel) {
        super(chart.getChart());
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(100, 100));
        this.chart = chart;
        this.isMainPanel = mainPanel;
        this.marksModel = Context.lookup(MarksModel.class);
        this.logMarklinesVisibilityModel = this.marksModel.getCategoriesModel();
        BaseChartPanelEx.LabelsVisibilitySupport labelsVisibilitySupport = new BaseChartPanelEx.LabelsVisibilitySupport(this, this);
        this.setMouseZoomable(mouseZoomable);
        this.addChartMouseListener(new BaseChartPanelEx.ChartMouseListenerImpl(this));
        if (this.isMainPanel) {
            JPopupMenu menu = this.getPopupMenu();
            menu.addSeparator();
            menu.add(labelsVisibilitySupport.getMenuPresenter());
            menu.addSeparator();
            menu.add(UIUtils.createGCLAPropertyActivationMenuItem("Use GC Type-specific shapes", "USE_GC_TYPE_SPECIFIC_SHAPES"));
            menu.add(UIUtils.createGCLAPropertyActivationMenuItem("Draw Selected Event Phases", "DRAW_EVENT_PHASES"));
            menu.add(UIUtils.createGCLAPropertyActivationMenuItem("Show Item# in Tooltips", "SHOW_ITEM_NUM_IN_TOOLTIP"));
            menu.addSeparator();
            menu.add(this.createCopyChartTitleMenuItem());
        } else {
            this.setPopupMenu(null);
        }
        if (chart.isMainChart()) {
            final JPanel toggleButtonsPanel = new JPanel();
            toggleButtonsPanel.setOpaque(false);
            int id = chart.getGraphDefinition().getID();
            toggleButtonsPanel.add(new FavoriteToggleButton(id));
            LayoutManager layoutManager = new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return parent.getPreferredSize();
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return parent.getMinimumSize();
                }

                @Override
                public void layoutContainer(Container parent) {
                    Dimension preferred = toggleButtonsPanel.getPreferredSize();
                    toggleButtonsPanel.setBounds(parent.getWidth() - preferred.width, 0, preferred.width, preferred.height);
                }
            };
            this.setLayout(layoutManager);
            this.add(toggleButtonsPanel);
        }
        KeyStroke copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
        KeyStroke shift_copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK | 0x40, false);
        this.registerKeyboardAction(new BaseChartPanelEx.CopyJFreeChartElement(false), "COPY", copy, 0);
        this.registerKeyboardAction(new BaseChartPanelEx.CopyJFreeChartElement(true), "COPY", shift_copy, 0);
        this.changeListener = new BaseChartPanelEx.ChangeListenerImpl(chart);
        this.displayTimeModel = Context.lookup(DisplayTimeModel.class);
        this.displayTimeModelListener = e -> {
            NumberAxisEx axis = new NumberAxisEx();
            axis.setVisible(this.isMainPanel);
            chart.getChart().getXYPlot().setDomainAxis(axis);
        };
    }

    @Override
    protected boolean isMainPanel() {
        return this.isMainPanel;
    }

    @Override
    protected GraphDefinition getGraphDefinition() {
        return this.chart.getGraphDefinition();
    }

    @Override
    protected JFreeChartRecordElement createChartRecordElement(XYItemEntity e) {
        return this.chart.createInfoElementFor(e);
    }

    @Override
    protected String getSaveAsFileName() {
        return this.chart.getGraphDefinition().getDefaultSaveAsFileName();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.marksModel.addChangeListener(this.changeListener);
        this.logMarklinesVisibilityModel.addChangeListener(this.changeListener);
        this.displayTimeModel.addChangeListener(this.displayTimeModelListener);
        this.displayTimeModelListener.stateChanged(null);
        Config.addPropertyChangeListener("DRAW_EVENT_PHASES", this.changeListener);
        Config.addPropertyChangeListener("USE_GC_TYPE_SPECIFIC_SHAPES", this.changeListener);
    }

    @Override
    public void removeNotify() {
        Config.removePropertyChangeListener("USE_GC_TYPE_SPECIFIC_SHAPES", this.changeListener);
        Config.removePropertyChangeListener("DRAW_EVENT_PHASES", this.changeListener);
        this.logMarklinesVisibilityModel.removeChangeListener(this.changeListener);
        this.marksModel.removeChangeListener(this.changeListener);
        this.displayTimeModel.removeChangeListener(this.displayTimeModelListener);
        super.removeNotify();
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ViewsNavigationPanel.processNavigationMouseListener(e);
        super.mousePressed(e);
    }

    private JMenuItem createCopyChartTitleMenuItem() {
        JMenuItem copyChartTitle = new JMenuItem("Copy Chart Title");
        copyChartTitle.addActionListener(action -> Optional.ofNullable(this.chart).map(ChartEx::getChart).map(JFreeChart::getTitle).map(TextTitle::getText).ifPresent(UIUtils::copyTextToClipboard));
        return copyChartTitle;
    }
}

