/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.PlotSeriesVisibilityModel;
import com.azul.log.gui.model.ScratchpadModel;
import com.azul.log.gui.model.support.AbstractModel;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public final class PlotSeriesVisibilitySupport {
    private static final Map<Integer, boolean[]> map = new HashMap<Integer, boolean[]>();

    private PlotSeriesVisibilitySupport() {
    }

    public static PlotSeriesVisibilityModel createChartSeriesVisibilityModel(GraphDefinition gd, JFreeChart chart) {
        return new PlotSeriesVisibilityModelImpl(gd, chart);
    }

    public static PlotSeriesVisibilityModel createScratchpadSeriesVisibilityModel(XYPlot plot, Map<GraphDefinition, Integer> displayedGraphs) {
        ScratchpadSeriesVisibilityModelImpl model = new ScratchpadSeriesVisibilityModelImpl(plot, displayedGraphs);
        return model.isEmpty() ? null : model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] getSeriesVisibilityState(int graphID) {
        Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
        synchronized (map) {
            return (boolean[])PlotSeriesVisibilitySupport.map.get(graphID).clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSeriesVisibilityState(int graphID, boolean[] state) {
        Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
        synchronized (map) {
            PlotSeriesVisibilitySupport.map.put(graphID, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
        synchronized (map) {
            PlotSeriesVisibilitySupport.map.clear();
        }
    }

    private static class ScratchpadSeriesVisibilityModelImpl
    extends AbstractModel
    implements PlotSeriesVisibilityModel {
        private final List<PlotSeriesVisibilityModel.SeriesInfo> data;
        private final int graphsCount;
        private final JFreeChart chart;

        private ScratchpadSeriesVisibilityModelImpl(XYPlot plot, Map<GraphDefinition, Integer> displayedGraphs) {
            this.graphsCount = displayedGraphs.size();
            this.data = this.initData(plot, displayedGraphs);
            this.chart = plot.getChart();
        }

        @Override
        public List<PlotSeriesVisibilityModel.SeriesInfo> getSeriesInfoData() {
            return this.data;
        }

        @Override
        public int getMenuPresentersCount() {
            return this.data.size() + this.graphsCount - 1;
        }

        @Override
        public PlotSeriesVisibilityModel.SeriesInfo getInfoForLegend(LegendItemEntity e) {
            GraphDefinition gd = ScratchpadModel.getModel().getGraphDefinitionForDataset(this.chart.getXYPlot(), (XYDataset)e.getDataset());
            int graphID = gd.getID();
            Optional<PlotSeriesVisibilityModel.SeriesInfo> result = this.data.stream().filter(s -> graphID == s.getGraphID() && s.getLabel().equals(e.getSeriesKey())).findFirst();
            return result.orElse(null);
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PlotSeriesVisibilityModel.SeriesInfo> initData(XYPlot plot, Map<GraphDefinition, Integer> displayedGraphs) {
            ArrayList<PlotSeriesVisibilityModel.SeriesInfo> info = new ArrayList<PlotSeriesVisibilityModel.SeriesInfo>();
            ArrayList<Map.Entry<GraphDefinition, Integer>> orderedGraphs = new ArrayList<Map.Entry<GraphDefinition, Integer>>(displayedGraphs.entrySet());
            orderedGraphs.sort(Map.Entry.comparingByValue());
            for (Map.Entry entry : orderedGraphs) {
                boolean[] data;
                int datasetIndex = (Integer)entry.getValue();
                int graphID = ((GraphDefinition)entry.getKey()).getID();
                XYDataset currDataset = plot.getDataset(datasetIndex);
                if (!(currDataset instanceof TimeSeriesCollection)) {
                    throw new InternalError("Unexpected dataset type for scratchpad");
                }
                int totalSeries = currDataset.getSeriesCount();
                Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
                synchronized (map) {
                    data = PlotSeriesVisibilitySupport.map.get(graphID);
                    if (data == null) {
                        data = new boolean[totalSeries];
                        Arrays.fill(data, true);
                        PlotSeriesVisibilitySupport.map.put(graphID, data);
                    }
                }
                for (int seriesCount = 0; seriesCount < totalSeries; ++seriesCount) {
                    info.add(new SeriesInfoImpl((TimeSeriesCollection)currDataset, plot.getRenderer(datasetIndex), seriesCount, graphID, data[seriesCount]));
                }
            }
            return info;
        }

        @Override
        public void showAll(boolean show) {
            if (this.data.stream().map(SeriesInfoImpl.class::cast).map(i -> i.setVisible(show, false)).reduce(false, (st, res) -> st | res).booleanValue()) {
                this.chart.fireChartChanged();
            }
        }

        private final class SeriesInfoImpl
        implements PlotSeriesVisibilityModel.SeriesInfo {
            private final TimeSeriesCollection dataset;
            private final XYItemRenderer renderer;
            private final int seriesIndex;
            private final int graphID;
            private final String label;

            private SeriesInfoImpl(TimeSeriesCollection dataset, XYItemRenderer renderer, int seriesIndex, int graphID, boolean init) {
                this.dataset = dataset;
                this.renderer = renderer;
                this.seriesIndex = seriesIndex;
                this.graphID = graphID;
                this.label = dataset.getSeries(seriesIndex).getDescription();
                this.setVisible(init, false);
            }

            @Override
            public String getLabel() {
                return this.label;
            }

            @Override
            public int getGraphID() {
                return this.graphID;
            }

            @Override
            public Paint getPaint() {
                return this.renderer.getSeriesPaint(this.seriesIndex);
            }

            @Override
            public boolean isVisible() {
                return this.hasData() && this.renderer.isSeriesVisible(this.seriesIndex);
            }

            @Override
            public void setVisible(boolean visible) {
                this.setVisible(visible, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean setVisible(boolean visible, boolean notify) {
                if (this.hasData()) {
                    Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
                    synchronized (map) {
                        PlotSeriesVisibilitySupport.map.get((Object)Integer.valueOf((int)this.graphID))[this.seriesIndex] = visible;
                    }
                    Boolean current = this.renderer.getSeriesVisible(this.seriesIndex);
                    if (current != null && current == visible) {
                        return false;
                    }
                    this.renderer.setSeriesVisible(this.seriesIndex, visible, notify);
                } else {
                    this.renderer.setSeriesVisible(this.seriesIndex, false, notify);
                }
                if (notify) {
                    ScratchpadSeriesVisibilityModelImpl.this.fireChange();
                }
                return true;
            }

            @Override
            public boolean hasData() {
                return !this.dataset.getSeries(this.seriesIndex).isEmpty();
            }
        }
    }

    private static class PlotSeriesVisibilityModelImpl
    extends AbstractModel
    implements PlotSeriesVisibilityModel {
        private final List<PlotSeriesVisibilityModel.SeriesInfo> data;
        private final Integer graphID;
        private final JFreeChart chart;

        private PlotSeriesVisibilityModelImpl(GraphDefinition gd, JFreeChart chart) {
            this.graphID = gd.getID();
            this.data = this.initData(gd, chart);
            this.chart = chart;
        }

        @Override
        public List<PlotSeriesVisibilityModel.SeriesInfo> getSeriesInfoData() {
            return this.data;
        }

        @Override
        public int getMenuPresentersCount() {
            return this.data.size();
        }

        @Override
        public PlotSeriesVisibilityModel.SeriesInfo getInfoForLegend(LegendItemEntity e) {
            XYDataset dataset = (XYDataset)e.getDataset();
            int index = dataset.indexOf(e.getSeriesKey());
            return this.data.get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PlotSeriesVisibilityModel.SeriesInfo> initData(GraphDefinition gd, JFreeChart chart) {
            boolean[] data;
            LegendItemCollection legendItems = chart.getPlot().getLegendItems();
            ArrayList<PlotSeriesVisibilityModel.SeriesInfo> info = new ArrayList<PlotSeriesVisibilityModel.SeriesInfo>();
            Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
            synchronized (map) {
                data = PlotSeriesVisibilitySupport.map.get(this.graphID);
                if (data == null) {
                    data = gd.getInitialSeriesVisibilityState();
                    if (data.length != legendItems.getItemCount()) {
                        throw new InternalError("Unexpected difference in sizes");
                    }
                    PlotSeriesVisibilitySupport.map.put(this.graphID, data);
                }
            }
            Iterator it = legendItems.iterator();
            XYPlot plot = (XYPlot)chart.getPlot();
            int idx = 0;
            while (it.hasNext()) {
                LegendItem i = (LegendItem)it.next();
                XYItemRenderer r = plot.getRenderer(i.getDatasetIndex());
                info.add(new SeriesInfoImpl(gd.getID(), i, r, data[idx++]));
            }
            return info;
        }

        @Override
        public void showAll(boolean show) {
            if (this.data.stream().map(SeriesInfoImpl.class::cast).map(i -> i.setVisible(show, false)).reduce(false, (st, res) -> st | res).booleanValue()) {
                this.chart.fireChartChanged();
                this.fireChange();
            }
        }

        private final class SeriesInfoImpl
        implements PlotSeriesVisibilityModel.SeriesInfo {
            private final LegendItem item;
            private final XYItemRenderer renderer;
            private final int graphID;

            public SeriesInfoImpl(int graphID, LegendItem i, XYItemRenderer r, boolean init) {
                this.item = i;
                this.renderer = r;
                this.graphID = graphID;
                this.setVisible(init, false);
            }

            @Override
            public String getLabel() {
                return this.item.getLabel();
            }

            @Override
            public int getGraphID() {
                return this.graphID;
            }

            @Override
            public boolean isVisible() {
                return this.hasData() && this.renderer.isSeriesVisible(this.item.getSeriesIndex());
            }

            @Override
            public boolean hasData() {
                Dataset dataset = this.item.getDataset();
                if (dataset instanceof TimeSeriesCollection) {
                    TimeSeriesCollection c = (TimeSeriesCollection)dataset;
                    TimeSeries s = c.getSeries(this.item.getSeriesIndex());
                    return !s.isEmpty();
                }
                return false;
            }

            @Override
            public void setVisible(boolean visible) {
                this.setVisible(visible, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean setVisible(boolean visible, boolean notify) {
                if (this.hasData()) {
                    Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
                    synchronized (map) {
                        PlotSeriesVisibilitySupport.map.get((Object)Integer.valueOf((int)this.graphID))[this.item.getSeriesIndex()] = visible;
                    }
                    Boolean current = this.renderer.getSeriesVisible(this.item.getSeriesIndex());
                    if (current != null && current == visible) {
                        return false;
                    }
                    this.renderer.setSeriesVisible(this.item.getSeriesIndex(), visible, notify);
                    this.item.setLabelPaint(visible ? Color.BLACK : new Color(150, 150, 150));
                } else {
                    this.renderer.setSeriesVisible(this.item.getSeriesIndex(), false, notify);
                    this.item.setLabelPaint(new Color(230, 230, 230));
                }
                if (notify) {
                    PlotSeriesVisibilityModelImpl.this.fireChange();
                }
                return true;
            }

            @Override
            public Paint getPaint() {
                return this.renderer.getSeriesPaint(this.item.getSeriesIndex());
            }
        }
    }
}

