/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public final class LogFilesModel {
    private final List<LogFile> logFiles = new ArrayList<LogFile>();

    public LogFilesModel(List<LogFile> logFiles) {
        this.logFiles.addAll(logFiles);
        this.logFiles.sort(LogFilesModel::compare);
    }

    public static int compare(LogFile f1, LogFile f2) {
        LogModel m1 = f1.lookup(LogModel.class);
        LogModel m2 = f2.lookup(LogModel.class);
        return Comparator.comparing(LogModel::getModelID).thenComparing(LogModel::getLogName).compare(m1, m2);
    }

    public List<LogFile> getLogFiles() {
        return Collections.unmodifiableList(this.logFiles);
    }

    public <T> Collection<T> lookupAll(Class<T> klass) {
        HashSet<T> result = new HashSet<T>();
        for (LogFile openFile : this.logFiles) {
            result.addAll(openFile.getLookup().lookupAll(klass));
        }
        return result;
    }
}

