/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class LogTimeModel {
    private static final ZoneId UTC = ZoneId.of("UTC");
    private ZoneId timeZoneId = UTC;
    private AbsoluteTimestamp absoluteTimestampBase;
    private RelativeTimestamp firstEventRelativeTimestamp = RelativeTimestamp.of(Double.MAX_VALUE, TimeUnit.SECONDS);
    private RelativeTimestamp lastEventRelativeTimestamp = RelativeTimestamp.of(0.0, TimeUnit.SECONDS);

    public static LogTimeModel getCompoundLogTimeModelAndFixupLogModels(Collection<LogFile> logFiles) {
        LogTimeModel compoundTimeModel = new LogTimeModel();
        List<LogTimeModel> timeModels = logFiles.stream().map(logFile -> logFile.lookup(LogTimeModel.class)).collect(Collectors.toList());
        AbsoluteTimestamp start = AbsoluteTimestamp.of((double)System.currentTimeMillis(), LogUnits.MILLISECONDS);
        ArrayList<LogTimeModel> toPatch = new ArrayList<LogTimeModel>();
        for (LogTimeModel model : timeModels) {
            AbsoluteTimestamp modelStart = model.getAbsoluteTimestampBase();
            if (modelStart == null) {
                toPatch.add(model);
                continue;
            }
            if (start.compareTo(modelStart) <= 0) continue;
            start = modelStart;
        }
        AbsoluteTimestamp earliest = start;
        toPatch.forEach(m -> m.setAbsoluteTimestampBase(earliest));
        timeModels.forEach(compoundTimeModel::extendTimeModel);
        for (LogFile logFile2 : logFiles) {
            RelativeTimestamp relativeTimestamp;
            LogTimeModel logTimeModel = logFile2.lookup(LogTimeModel.class);
            AbsoluteTimestamp startTime = logTimeModel.getAbsoluteTimestampBase();
            if (startTime == null || (relativeTimestamp = compoundTimeModel.toRelative(startTime)) == null) continue;
            long timeAdjustmentNano = relativeTimestamp.getInUnits(TimeUnit.NANOSECONDS);
            logFile2.lookup(LogModel.class).setTimeAdjustmentNano(timeAdjustmentNano);
        }
        return compoundTimeModel;
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public AbsoluteTimestamp getAbsoluteTimestampBase() {
        return this.absoluteTimestampBase;
    }

    public void setAbsoluteTimestampBase(AbsoluteTimestamp absoluteTimestampBase) {
        this.absoluteTimestampBase = absoluteTimestampBase;
    }

    public RelativeTimestamp getFirstEventRelativeTimestamp() {
        return this.firstEventRelativeTimestamp;
    }

    public RelativeTimestamp getLastEventRelativeTimestamp() {
        return this.lastEventRelativeTimestamp;
    }

    public void processAbsoluteTimestamp(AbsoluteTimestamp absoluteTimestamp) {
        if (this.absoluteTimestampBase == null || this.absoluteTimestampBase.compareTo(absoluteTimestamp) > 0) {
            this.absoluteTimestampBase = absoluteTimestamp;
        }
    }

    public void processRelativeTimestamp(RelativeTimestamp relativeTimestamp) {
        if ((this.firstEventRelativeTimestamp == null || this.firstEventRelativeTimestamp.compareTo(relativeTimestamp) > 0) && relativeTimestamp.getNs() > 0L) {
            this.firstEventRelativeTimestamp = relativeTimestamp;
        }
        if (this.lastEventRelativeTimestamp == null || this.lastEventRelativeTimestamp.compareTo(relativeTimestamp) < 0) {
            this.lastEventRelativeTimestamp = relativeTimestamp;
        }
    }

    public RelativeTimestamp toRelative(AbsoluteTimestamp absoluteTimestamp) {
        return absoluteTimestamp != null && this.absoluteTimestampBase != null ? RelativeTimestamp.of(AbsoluteTimestamp.delta(absoluteTimestamp, this.absoluteTimestampBase, TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS) : null;
    }

    public void extendTimeModel(LogTimeModel model) {
        if (model.timeZoneId != null) {
            this.timeZoneId = model.timeZoneId;
        }
        if (this.absoluteTimestampBase == null) {
            this.absoluteTimestampBase = model.absoluteTimestampBase;
            this.firstEventRelativeTimestamp = model.firstEventRelativeTimestamp;
            this.lastEventRelativeTimestamp = model.lastEventRelativeTimestamp;
        } else {
            double delta_ms = AbsoluteTimestamp.delta(this.absoluteTimestampBase, model.absoluteTimestampBase, TimeUnit.MILLISECONDS);
            if (delta_ms < 0.0) {
                RelativeTimestamp last;
                RelativeTimestamp first = model.firstEventRelativeTimestamp.shift(-delta_ms, LogUnits.MILLISECONDS);
                if (this.firstEventRelativeTimestamp.compareTo(first) > 0) {
                    this.firstEventRelativeTimestamp = first;
                }
                if (this.lastEventRelativeTimestamp.compareTo(last = model.lastEventRelativeTimestamp.shift(-delta_ms, LogUnits.MILLISECONDS)) < 0) {
                    this.lastEventRelativeTimestamp = last;
                }
            } else {
                RelativeTimestamp first = this.firstEventRelativeTimestamp.shift(delta_ms, LogUnits.MILLISECONDS);
                this.firstEventRelativeTimestamp = model.firstEventRelativeTimestamp.compareTo(first) < 0 ? model.firstEventRelativeTimestamp : first;
                RelativeTimestamp last = this.lastEventRelativeTimestamp.shift(delta_ms, LogUnits.MILLISECONDS);
                this.lastEventRelativeTimestamp = model.lastEventRelativeTimestamp.compareTo(last) > 0 ? model.lastEventRelativeTimestamp : last;
                this.absoluteTimestampBase = model.getAbsoluteTimestampBase();
            }
        }
    }
}

