/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.utils.TextUtils;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;

public final class RelativeTimestamp
implements Comparable<RelativeTimestamp> {
    private final long ns;

    private RelativeTimestamp(long ns) {
        this.ns = ns;
    }

    public static RelativeTimestamp of(double ts, LogUnits timeUnit) {
        return new RelativeTimestamp((long)timeUnit.convertTo(ts, LogUnits.NANOSECONDS));
    }

    public static RelativeTimestamp of(double ts, TimeUnit timeUnit) {
        return RelativeTimestamp.of(ts, LogUnits.of(timeUnit));
    }

    public static RelativeTimestamp delta(AbsoluteTimestamp ts1, AbsoluteTimestamp ts2) {
        return RelativeTimestamp.of((double)Math.abs(ts2.toEpochTime() - ts1.toEpochTime()), TimeUnit.MILLISECONDS);
    }

    public long getNs() {
        return this.ns;
    }

    public double getInUnits(LogUnits inUnit) {
        return LogUnits.NANOSECONDS.convertTo(this.ns, inUnit);
    }

    public long getInUnits(TimeUnit inUnit) {
        return (long)this.getInUnits(LogUnits.of(inUnit));
    }

    public RelativeTimestamp shift(double delta, LogUnits timeUnit) {
        return RelativeTimestamp.of((double)(this.ns + (long)timeUnit.convertTo(delta, LogUnits.NANOSECONDS)), LogUnits.NANOSECONDS);
    }

    public RelativeTimestamp shift(double delta, TimeUnit timeUnit) {
        return this.shift(delta, LogUnits.of(timeUnit));
    }

    public static double delta(RelativeTimestamp first, RelativeTimestamp second, LogUnits timeUnit) {
        return LogUnits.NANOSECONDS.convertTo(first.ns - second.ns, timeUnit);
    }

    public static double delta(RelativeTimestamp first, RelativeTimestamp second, TimeUnit timeUnit) {
        return RelativeTimestamp.delta(first, second, LogUnits.of(timeUnit));
    }

    public static RelativeTimestamp parse(CharSequence string, LogUnits inUnit) throws ParseException {
        char c;
        int i;
        for (i = 0; i < string.length() && (Character.isDigit(c = string.charAt(i)) || '.' == c || ',' == c); ++i) {
        }
        try {
            Double val = TextUtils.parseDouble(string.subSequence(0, i));
            if (val != null) {
                return RelativeTimestamp.of((double)val, inUnit);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ParseException("Unable to parse timestamp ->" + string + "<-", i);
    }

    public static RelativeTimestamp parse(CharSequence string, TimeUnit inUnit) throws ParseException {
        return RelativeTimestamp.parse(string, LogUnits.of(inUnit));
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelativeTimestamp) {
            RelativeTimestamp that = (RelativeTimestamp)obj;
            return this.ns == that.ns;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (int)(this.ns ^ this.ns >>> 32);
        return hash;
    }

    @Override
    public int compareTo(RelativeTimestamp o) {
        return Long.compare(this.ns, o.ns);
    }
}

