/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.C4_ParseReplaySupport;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.impl.c4.utils.C4_Utilities;
import com.azul.log.parser.support.LogDataFieldsAccessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Lookup;

abstract class C4_DataLineParser<T extends C4_LogRecord>
implements C4_LogLineParser {
    protected final Class<T> klass;
    protected final String header_marker;
    protected final String data_marker;
    protected final Map<String, Field> hdr_to_fld;
    private final Map<Integer, List<Field>> fieldsMap = new HashMap<Integer, List<Field>>();
    private final Map<Integer, List<Field>> aliasedFieldsMap = new HashMap<Integer, List<Field>>();
    private final LogDataFieldsAccessor accessor = LogDataFieldsAccessor.getInstance();

    public C4_DataLineParser(Class<T> klass) {
        this.klass = klass;
        C4_LogDataRecord annotation = klass.getAnnotation(C4_LogDataRecord.class);
        this.header_marker = annotation.header_marker();
        this.data_marker = annotation.data_marker();
        this.hdr_to_fld = this._init_fields();
    }

    private Map<String, Field> _init_fields() {
        return this.init_fields();
    }

    protected Map<String, Field> init_fields() {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : this.klass.getFields()) {
            if (!field.isAnnotationPresent(C4_GCLogRecordField.class)) continue;
            map.put(field.getAnnotation(C4_GCLogRecordField.class).header(), field);
        }
        return Collections.unmodifiableMap(map);
    }

    protected abstract boolean parseHeaderImpl(String var1) throws ParserException;

    protected String[] getFirstLineFixupMatrix() {
        return null;
    }

    @Override
    public C4_LogLineParser.DataLineParseResult parseDataLine(C4_ParserState state, C4_LogParser.DataLine dataLine) throws ParserException {
        if (this.data_marker.equals(dataLine.prefix)) {
            return this.parseDataLineImpl(state, dataLine);
        }
        if (this.header_marker.equals(dataLine.prefix) && this.parseHeaderImpl(dataLine.data)) {
            return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
        }
        return null;
    }

    protected C4_LogLineParser.DataLineParseResult parseDataLineImpl(C4_ParserState state, C4_LogParser.DataLine dataLine) throws ParserException {
        C4_LogRecord record;
        C4_Utilities.WordsList data = C4_Utilities.splitWords(dataLine.data);
        int fieldsCount = data.size();
        List<Field> fields = this.fieldsMap.get(fieldsCount);
        if (fields == null) {
            return null;
        }
        List<Field> aliasedFields = this.aliasedFieldsMap.get(fieldsCount);
        Field field = null;
        CharSequence value = null;
        try {
            record = (C4_LogRecord)this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (int i = 0; i < fieldsCount; ++i) {
                field = fields.get(i);
                if (field == null || ":".contentEquals(value = data.get(i))) continue;
                this.accessor.setFieldValueFromString(record, field, value);
                if (aliasedFields == null || (field = aliasedFields.get(i)) == null) continue;
                this.accessor.setFieldValueFromString(record, field, value);
            }
        }
        catch (Exception ex) {
            throw new ParserException("Cannot assign value '" + value + "' to field " + field + ". " + ex.getMessage());
        }
        try {
            this.computeCalculatedFields(record);
            this.accessor.resolveDefinedFields(record);
            return new C4_LogLineParser.DataLineParseResult(record);
        }
        catch (ParserException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ParserException(ex.getMessage());
        }
    }

    protected void computeCalculatedFields(T record) throws ParserException {
    }

    protected void defineFields(List<Field> fields) throws ParserException {
        this.fieldsMap.put(fields.size(), Collections.unmodifiableList(fields));
        ArrayList<Field> aliasedFields = new ArrayList<Field>(fields.size());
        boolean hasAliasedFields = false;
        for (Field f : fields) {
            C4_GCLogRecordField a;
            String aliasFieldName;
            Field aliasField = null;
            if (f != null && f.isAnnotationPresent(C4_GCLogRecordField.class) && !(aliasFieldName = (a = f.getAnnotation(C4_GCLogRecordField.class)).alias()).isEmpty()) {
                try {
                    aliasField = f.getDeclaringClass().getField(aliasFieldName);
                    hasAliasedFields = true;
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    throw new InternalError("Wrong mapsTo annotation for " + f.getDeclaringClass() + "." + f.getName());
                }
            }
            aliasedFields.add(aliasField);
        }
        if (hasAliasedFields) {
            this.aliasedFieldsMap.put(fields.size(), Collections.unmodifiableList(aliasedFields));
        }
        C4_ParseReplaySupport.replay(this.data_marker);
    }

    protected boolean shouldHandleFieldsWithKnownDelimiters() {
        return false;
    }

    protected String handleKnownDelimitersInFields(String data) {
        if (!this.shouldHandleFieldsWithKnownDelimiters()) {
            return data;
        }
        if (data.contains(":")) {
            data = data.replace(':', '=');
        }
        if (data.contains("'")) {
            String[] chunks = data.split("'", 3);
            data = String.join((CharSequence)"", chunks[0], "'", chunks[1].replace(' ', '='), "'", chunks[2]);
        }
        return data;
    }

    @Override
    public final void init(Lookup lookup) {
        this.init_impl(lookup);
        this.fieldsMap.clear();
        this.aliasedFieldsMap.clear();
    }

    protected void init_impl(Lookup lookup) {
    }

    List<Field> getFields(int cnt) {
        return this.fieldsMap.get(cnt);
    }

    List<Field> getAliasedFields(int cnt) {
        return this.aliasedFieldsMap.get(cnt);
    }
}

