/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class C4_FieldTypes {
    private C4_FieldTypes() {
    }

    public static final class TSCInfo
    extends LogFieldTypes.LogFieldType {
        public final State pstate;
        public final State tsc;
        public final State constant_tsc;
        public final State nonstop_tsc;
        public final State UseRdtsc;

        public TSCInfo() {
            this(Collections.emptyMap());
        }

        public TSCInfo(Map<String, String> info) {
            this.pstate = State.parse(info.get("pstate"));
            this.tsc = State.parse(info.get("tsc"));
            this.constant_tsc = State.parse(info.get("constant_tsc"));
            this.nonstop_tsc = State.parse(info.get("nonstop_tsc"));
            this.UseRdtsc = State.parse(info.get("UseRdtsc"));
        }

        public static TSCInfo fromString(String info, LogUnits defaultUnits) {
            String[] chunks = info.split(" ");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < chunks.length - 1; i += 2) {
                map.put(chunks[i], chunks[i + 1]);
            }
            return new TSCInfo(map);
        }

        public static enum State {
            ON,
            OFF,
            UNKNOWN;


            private static State parse(String state) {
                if (state == null) {
                    return UNKNOWN;
                }
                String st = state.toLowerCase();
                if ("on".equals(st) || "true".equals(st)) {
                    return ON;
                }
                if ("off".equals(st) || "false".equals(st)) {
                    return OFF;
                }
                return UNKNOWN;
            }
        }
    }

    public static final class CacheLocation
    extends LogFieldTypes.LogFieldType {
        private final String location;
        public static final CacheLocation JAVA_HEAP = new CacheLocation("Java Heap");
        public static final CacheLocation C_HEAP = new CacheLocation("C Heap");

        public CacheLocation() {
            this("Unknown");
        }

        private CacheLocation(String location) {
            this.location = location;
        }

        public static CacheLocation fromString(String info, LogUnits defaultUnits) {
            if (info.contains("Zing") || info.contains("Java Heap")) {
                return JAVA_HEAP;
            }
            if (info.contains("Linux") || info.contains("C Heap")) {
                return C_HEAP;
            }
            throw new IllegalArgumentException("Unknown CacheLocation: " + info);
        }

        public String toString() {
            return this.location;
        }
    }

    public static final class CPUInfo
    extends LogFieldTypes.LogFieldType {
        public final int processor_count;
        public final int active_processor_count;
        public final int physical_core_count;
        public final int assigned_logical_core_count;
        public final int assigned_physical_core_count;

        public CPUInfo() {
            this(0, 0, 0, 0, 0);
        }

        private CPUInfo(int processor_count) {
            this(processor_count, 0, 0, 0, 0);
        }

        private CPUInfo(int processor_count, int active_processor_count, int physical_core_count, int assigned_logical_core_count, int assigned_physical_core_count) {
            this.processor_count = processor_count;
            this.physical_core_count = physical_core_count;
            this.active_processor_count = active_processor_count;
            this.assigned_logical_core_count = assigned_logical_core_count;
            this.assigned_physical_core_count = assigned_physical_core_count;
        }

        public static CPUInfo fromString(String info, LogUnits defaultUnits) {
            String[] chunks = info.split(" ");
            if (chunks.length == 5) {
                return new CPUInfo(Integer.parseInt(chunks[0]), Integer.parseInt(chunks[1]), Integer.parseInt(chunks[2]), Integer.parseInt(chunks[3]), Integer.parseInt(chunks[4]));
            }
            if (chunks.length == 1) {
                return new CPUInfo(Integer.parseInt(chunks[0]));
            }
            throw new IllegalArgumentException();
        }
    }
}

