/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.impl.c4.spi.C4_LogLineFormat;
import com.azul.log.parser.utils.TextUtils;

final class C4_LegacyGCLogLineFormat
implements C4_LogLineFormat {
    C4_LegacyGCLogLineFormat() {
    }

    public static C4_LegacyGCLogLineFormat guess(CharSequence line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        if (!Character.isDigit(line.charAt(0)) && line.charAt(0) != '[') {
            return null;
        }
        if (line.charAt(0) != '[' && TextUtils.indexOf(line, ": ", 0) <= 0) {
            return null;
        }
        return new C4_LegacyGCLogLineFormat();
    }

    @Override
    public LogLineWithTime parse(CharSequence line) {
        if (line.length() == 0 || !Character.isDigit(line.charAt(0)) && line.charAt(0) != '[') {
            return null;
        }
        CharSequence absoluteTimestamp = null;
        CharSequence relativeTimestamp = null;
        int space_idx = 0;
        int data_start_idx = -1;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '[') {
                data_start_idx = i;
                break;
            }
            if (c == '-') {
                if (relativeTimestamp != null || (space_idx = TextUtils.indexOf(line, ": ", i)) == -1) {
                    return null;
                }
                absoluteTimestamp = line.subSequence(0, space_idx);
                data_start_idx = i = space_idx + 2;
                if (Character.isDigit(line.charAt(i))) {
                    space_idx = TextUtils.indexOf(line, ": ", i);
                    if (space_idx == -1) {
                        return null;
                    }
                    relativeTimestamp = line.subSequence(i, space_idx);
                    data_start_idx = i = space_idx + 1;
                    continue;
                }
                --i;
                continue;
            }
            if (c != '.') continue;
            int s = space_idx;
            space_idx = TextUtils.indexOf(line, ": ", i);
            if (space_idx == -1) {
                return null;
            }
            relativeTimestamp = line.subSequence(s, space_idx);
            data_start_idx = i = space_idx + 1;
        }
        return new LogLineWithTime(absoluteTimestamp, relativeTimestamp, data_start_idx, line);
    }
}

