/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogSummary;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.records.CNCStatsRecord;
import com.azul.log.parser.impl.c4.records.CompstatsRecord;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.records.ProfChunkInfoRecord;
import com.azul.log.parser.impl.c4.records.ProfErrRecord;
import com.azul.log.parser.impl.c4.records.ProfInfoRecord;
import com.azul.log.parser.impl.c4.records.ProfMsgRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.openide.util.Lookup;

public final class C4_Summary
implements LogSummary {
    public long codeCacheUseMax = -1L;
    public long codeCacheAllocatedMax = -1L;
    public long javaHeapUseMax = -1L;
    public long monitorCacheUseMax = -1L;
    public long monitorCacheAllocatedMax = -1L;
    public int compTier1Threads = -1;
    public int compTier2Threads = -1;
    public int newGCThreads = -1;
    public int oldGCThreads = -1;
    public CNCStatsRecord cncStats = null;
    public ProfInfoRecord profInfo = null;
    public ProfileSummary inputProfileSummary = new ProfileSummary("Input");
    public ProfileSummary outputProfileSummary = new ProfileSummary("Output");
    private final Map<Class<? extends LogRecord>, Consumer<LogRecord>> map = new HashMap<Class<? extends LogRecord>, Consumer<LogRecord>>();
    private final Lookup lookup;

    public C4_Summary(Lookup lookup) {
        this.lookup = lookup;
    }

    public void processRecord(LogRecord logRecord) {
        this.map.computeIfAbsent(logRecord.getClass(), logRecordClass -> {
            if (logRecordClass.isAssignableFrom(GCRecord.class)) {
                return this::processGCRecord;
            }
            if (logRecordClass.isAssignableFrom(CompstatsRecord.class)) {
                return this::processCompstatsRecord;
            }
            if (logRecordClass.isAssignableFrom(ProfInfoRecord.class)) {
                return this::processProfInfoRecord;
            }
            if (logRecordClass.isAssignableFrom(ProfChunkInfoRecord.class)) {
                return this::processProfChunkInfoRecord;
            }
            if (logRecordClass.isAssignableFrom(CNCStatsRecord.class)) {
                return this::processCNCStatsRecord;
            }
            if (logRecordClass.isAssignableFrom(ProfErrRecord.class)) {
                return this::processProfErrRecord;
            }
            if (logRecordClass.isAssignableFrom(ProfMsgRecord.class)) {
                return this::processProfMsgRecord;
            }
            return record -> {};
        }).accept(logRecord);
    }

    private C4_LogHeader getC4LogHeader() {
        return this.lookup.lookup(C4_LogHeader.class);
    }

    private void processGCRecord(LogRecord record) {
        GCRecord gcRecord = (GCRecord)record;
        this.codeCacheUseMax = Math.max(this.codeCacheUseMax, (long)gcRecord.code_cache_used_mb);
        this.codeCacheAllocatedMax = Math.max(this.codeCacheAllocatedMax, (long)gcRecord.code_cache_cap_mb);
        this.monitorCacheAllocatedMax = this.monitorCacheUseMax = Math.max(this.monitorCacheUseMax, (long)gcRecord.monitor_cache_used_mb);
        this.javaHeapUseMax = Math.max(this.javaHeapUseMax, (long)gcRecord.peak);
        if (this.newGCThreads < 0 && gcRecord.isNew()) {
            this.newGCThreads = gcRecord.thread_count;
        }
        if (this.oldGCThreads < 0 && gcRecord.isOld()) {
            this.oldGCThreads = gcRecord.thread_count;
        }
    }

    private void processCompstatsRecord(LogRecord record) {
        CompstatsRecord compstatsRecord = (CompstatsRecord)record;
        if (compstatsRecord.threads_total > 0) {
            if ("1".equals(compstatsRecord.tier)) {
                this.compTier1Threads = Math.max(this.compTier1Threads, compstatsRecord.threads_total);
            } else {
                this.compTier2Threads = Math.max(this.compTier2Threads, compstatsRecord.threads_total);
            }
        }
    }

    private void processProfInfoRecord(LogRecord record) {
        ProfInfoRecord profInfoRecord = (ProfInfoRecord)record;
        if (this.profInfo == null || this.profInfo.generation < profInfoRecord.generation) {
            this.profInfo = profInfoRecord;
            this.inputProfileSummary.generation = profInfoRecord.generation;
            this.inputProfileSummary.profileId = profInfoRecord.id;
            this.inputProfileSummary.sizeInBytes = profInfoRecord.byteSize;
            this.inputProfileSummary.expectedChunkCount = profInfoRecord.chunkCount;
            this.inputProfileSummary.lastUpdateEpochTimeMillis = profInfoRecord.lastUpdated;
        }
    }

    private void processProfChunkInfoRecord(LogRecord record) {
        ProfileSummary profileSummary;
        ProfChunkInfoRecord profChunkInfoRecord = (ProfChunkInfoRecord)record;
        ProfileSummary profileSummary2 = profileSummary = profChunkInfoRecord.isIncoming() ? this.inputProfileSummary : this.outputProfileSummary;
        if (profChunkInfoRecord.seqNumber == -1) {
            return;
        }
        if (profileSummary.firstChuck == null) {
            profileSummary.firstChuck = profChunkInfoRecord;
        }
        ++profileSummary.actualChunkCount;
        profileSummary.lastChunk = profChunkInfoRecord;
        if (profileSummary.isOutputProfile()) {
            profileSummary.sizeInBytes += profChunkInfoRecord.sizeInBytes;
            profileSummary.expectedChunkCount = profileSummary.actualChunkCount;
            profileSummary.lastUpdateEpochTimeMillis = (double)this.getC4LogHeader().jvm_start_time.toEpochTime() + profChunkInfoRecord.getEventRelativeTimestampEx().getInUnits(LogUnits.MILLISECONDS);
        }
    }

    private void processCNCStatsRecord(LogRecord record) {
        if (this.cncStats == null) {
            this.cncStats = (CNCStatsRecord)record;
            this.outputProfileSummary.profileId = this.cncStats.vmId;
        }
    }

    private void processProfErrRecord(LogRecord record) {
        ProfErrRecord profErrRecord = (ProfErrRecord)record;
        this.inputProfileSummary.additionalInfo.add("ERROR : " + profErrRecord.errorLogLine);
    }

    private void processProfMsgRecord(LogRecord record) {
        ProfMsgRecord profMsgRecord = (ProfMsgRecord)record;
        this.outputProfileSummary.additionalInfo.add(profMsgRecord.msgLogLine);
    }

    public class ProfileSummary {
        private String profileId = "NA";
        private int generation = -1;
        private long sizeInBytes = -1L;
        private int expectedChunkCount = 0;
        private int actualChunkCount = 0;
        private double lastUpdateEpochTimeMillis;
        private ProfChunkInfoRecord firstChuck;
        private ProfChunkInfoRecord lastChunk;
        private final List<String> additionalInfo = new ArrayList<String>();
        private final String profileType;

        private ProfileSummary(String profileType) {
            this.profileType = profileType;
        }

        public boolean isInputProfile() {
            return this.profileType.equals("Input");
        }

        public boolean isOutputProfile() {
            return !this.isInputProfile();
        }

        public boolean isSummaryAvailable() {
            if (this.isInputProfile()) {
                return C4_Summary.this.profInfo != null;
            }
            return this.actualChunkCount > 0;
        }

        public int getGeneration() {
            if (this.isOutputProfile()) {
                return C4_Summary.this.inputProfileSummary.generation + 1;
            }
            return this.generation;
        }

        public String getProfileId() {
            return this.profileId;
        }

        public double getLastUpdateEpochTimeMillis() {
            return this.lastUpdateEpochTimeMillis;
        }

        public int getExpectedChunkCount() {
            return this.expectedChunkCount;
        }

        public int getActualChunkCount() {
            return this.actualChunkCount;
        }

        public ProfChunkInfoRecord getFirstChuck() {
            return this.firstChuck;
        }

        public ProfChunkInfoRecord getLastChunk() {
            return this.lastChunk;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public String getProfileType() {
            return this.profileType;
        }

        public String getTimeInfo() {
            if (this.getFirstChuck() != null && this.getLastChunk() != null) {
                double startTimeInSeconds = this.getFirstChuck().getEventRelativeTimestamp().getInUnits(LogUnits.SECONDS);
                double endTimeInSeconds = this.getLastChunk().getEventRelativeTimestamp().getInUnits(LogUnits.SECONDS);
                if (this.isInputProfile()) {
                    if (this.getExpectedChunkCount() == this.getActualChunkCount()) {
                        return String.format("Profile load started at %.2fs, successfully downloaded %d/%d chunk(s) and finished at %.2fs (took %.2fs)", startTimeInSeconds, this.getActualChunkCount(), this.getExpectedChunkCount(), endTimeInSeconds, endTimeInSeconds - startTimeInSeconds);
                    }
                    return String.format("Profile load started at %.2fs, downloaded only %d/%d chunk(s)", startTimeInSeconds, this.getActualChunkCount(), this.getExpectedChunkCount());
                }
                boolean isNormalTermination = this.additionalInfo.stream().anyMatch(s -> s.contains("Profile generation has exceeded number of concurrent recordings"));
                return String.format("Profile output started at %.2fs, uploaded %d chunk(s) with most recent at %.2fs%s", startTimeInSeconds, this.getActualChunkCount(), endTimeInSeconds, isNormalTermination ? ", normal termination by OptHub" : "");
            }
            return "NA";
        }

        public List<String> getAdditionalInfo() {
            if (this.isInputProfile() && this.getExpectedChunkCount() != this.getActualChunkCount() && this.additionalInfo.isEmpty()) {
                return List.of("ERROR: Failed to download remote profile", "ERROR: Unable to load remote profile");
            }
            return this.additionalInfo;
        }
    }
}

