/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.impl.c4.spi.C4_LogLineFormat;
import com.azul.log.parser.utils.TextUtils;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

final class C4_UnifiedGCLogLineFormat
implements C4_LogLineFormat {
    private static final SimpleDateFormat time_fmt = C4_UnifiedGCLogLineFormat.initTimeFormat();
    private Decorator[] decorators;

    private C4_UnifiedGCLogLineFormat(Decorator[] decorators) {
        this.decorators = decorators;
    }

    private static SimpleDateFormat initTimeFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt;
    }

    public static C4_UnifiedGCLogLineFormat guess(CharSequence line) {
        int i;
        if (line == null || line.length() == 0) {
            return null;
        }
        if (line.charAt(0) != '[') {
            return null;
        }
        int start = 0;
        ArrayList<CharSequence> fields = new ArrayList<CharSequence>();
        StringBuilder sb = new StringBuilder();
        boolean in_decorator = false;
        block4: for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!in_decorator && c == ' ') break;
            switch (c) {
                case '[': {
                    start = i + 1;
                    sb.setLength(0);
                    in_decorator = true;
                    continue block4;
                }
                case ']': {
                    int end = i;
                    fields.add(line.subSequence(start, end));
                    in_decorator = false;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (i >= line.length() || line.charAt(i) != ' ' || fields.isEmpty()) {
            return null;
        }
        ArrayList<Decorator> decorators = new ArrayList<Decorator>();
        for (CharSequence field : fields) {
            Decorator decorator = Decorator.guess(TextUtils.trim(field));
            if (decorator == null) {
                return null;
            }
            decorators.add(decorator);
        }
        return new C4_UnifiedGCLogLineFormat(decorators.toArray(new Decorator[0]));
    }

    private DecorationsParseResult parseDecorations(CharSequence line) {
        try {
            return this.parseDecorationsExpectExceptions(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    private DecorationsParseResult parseDecorationsExpectExceptions(CharSequence line) {
        int pos = 0;
        CharSequence absTime = null;
        Object relTime = null;
        block6: for (Decorator decorator : this.decorators) {
            if (line.charAt(pos) != '[') {
                return null;
            }
            switch (decorator) {
                case TIME: {
                    absTime = line.subSequence(pos + 1, pos + 29);
                    pos += 30;
                    continue block6;
                }
                case UPTIME_S: {
                    int tmp = this.readNum(line, 's', pos + 1);
                    if (tmp < 0) {
                        return null;
                    }
                    relTime = line.subSequence(pos + 1, tmp);
                    pos = tmp + 2;
                    continue block6;
                }
                case TIME_MS: 
                case UPTIME_MS: {
                    StringBuffer sb;
                    long l;
                    CharSequence tmpTime;
                    int tmp = this.readNum(line, 'm', pos + 1);
                    if (tmp < 0) {
                        return null;
                    }
                    if (relTime == null || absTime == null) {
                        tmpTime = line.subSequence(pos + 1, tmp);
                        l = Long.parseLong((String)tmpTime);
                        if (decorator == Decorator.UPTIME_MS) {
                            relTime = "" + RelativeTimestamp.of((double)l, TimeUnit.MILLISECONDS).getInUnits(LogUnits.SECONDS);
                        } else {
                            sb = new StringBuffer();
                            time_fmt.format(new Date(l), sb, new FieldPosition(0));
                            absTime = sb.toString();
                        }
                    }
                    pos = tmp + 3;
                    continue block6;
                }
                case UPTIME_NS: {
                    StringBuffer sb;
                    long l;
                    CharSequence tmpTime;
                    int tmp = this.readNum(line, 'n', pos + 1);
                    if (tmp < 0) {
                        return null;
                    }
                    if (relTime == null || absTime == null) {
                        tmpTime = line.subSequence(pos + 1, tmp);
                        l = Long.parseLong((String)tmpTime);
                        if (decorator == Decorator.UPTIME_NS) {
                            relTime = "" + RelativeTimestamp.of((double)l, TimeUnit.NANOSECONDS).getInUnits(LogUnits.SECONDS);
                        } else {
                            sb = new StringBuffer();
                            time_fmt.format(new Date(TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS) * 10L), sb, new FieldPosition(0));
                            absTime = sb.toString();
                        }
                    }
                    pos = tmp + 3;
                    continue block6;
                }
                default: {
                    int tmp = TextUtils.indexOf(line, ']', pos);
                    if (tmp < 0) {
                        return null;
                    }
                    pos = tmp + 1;
                    if (pos < line.length()) continue block6;
                    return null;
                }
            }
        }
        if (pos >= line.length() - 2) {
            return null;
        }
        if (line.charAt(pos) != ' ') {
            return null;
        }
        return new DecorationsParseResult(absTime, (CharSequence)relTime, pos);
    }

    private int readNum(CharSequence line, char suffix, int pos) {
        while (pos < line.length()) {
            char c = line.charAt(pos);
            if (c == suffix) {
                return pos;
            }
            if ((c < '0' || c > '9') && c != '.' && c != ',') break;
            ++pos;
        }
        return -1;
    }

    @Override
    public LogLineWithTime parse(CharSequence line) {
        if (line == null || line.length() == 0 || line.charAt(0) != '[') {
            return null;
        }
        DecorationsParseResult dpr = this.parseDecorations(line);
        if (dpr == null) {
            C4_UnifiedGCLogLineFormat f = C4_UnifiedGCLogLineFormat.guess(line);
            if (f == null) {
                return null;
            }
            this.decorators = f.decorators;
            dpr = this.parseDecorations(line);
        }
        return dpr == null ? null : new LogLineWithTime(dpr.absoluteTimestamp, dpr.relativeTimestamp, dpr.decorationsLength, line);
    }

    private static final class DecorationsParseResult {
        private final CharSequence absoluteTimestamp;
        private final CharSequence relativeTimestamp;
        private final int decorationsLength;

        public DecorationsParseResult(CharSequence absoluteTimestamp, CharSequence relativeTimestamp, int decorationsLength) {
            this.absoluteTimestamp = absoluteTimestamp;
            this.relativeTimestamp = relativeTimestamp;
            this.decorationsLength = decorationsLength;
        }
    }

    static enum Decorator {
        TIME,
        UPTIME_S,
        TIME_MS,
        UPTIME_MS,
        TIME_NS,
        UPTIME_NS,
        OTHER;

        private static final NumberFormat intFormat;
        private static final long YEAR_MS = 31536000000L;
        private static final long YEAR_NS = 31536000000000L;

        private static Decorator guess(CharSequence str) {
            String field = str.toString();
            try {
                time_fmt.parse(field);
                return TIME;
            }
            catch (ParseException parseException) {
                char c;
                int i;
                for (i = 0; i < field.length() && (Character.isDigit(c = field.charAt(i)) || c == '.' || c == ','); ++i) {
                }
                if (i == 0) {
                    return OTHER;
                }
                try {
                    switch (field.substring(i)) {
                        case "s": {
                            return UPTIME_S;
                        }
                        case "ms": {
                            long val = intFormat.parse(field).longValue();
                            return val > 31536000000L ? TIME_MS : UPTIME_MS;
                        }
                        case "ns": {
                            long val = intFormat.parse(field).longValue();
                            return val > 31536000000000L ? TIME_NS : UPTIME_NS;
                        }
                        case "": {
                            return OTHER;
                        }
                    }
                }
                catch (ParseException parseException2) {
                    // empty catch block
                }
                return null;
            }
        }

        static {
            intFormat = NumberFormat.getIntegerInstance();
        }
    }
}

