/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.advisor;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.impl.c4.advisor.utils.Utils;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.records.HugePageStatRecord;
import com.azul.log.parser.impl.c4.records.SafepointRecord;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;
import com.azul.log.parser.impl.c4.records.VmaCountersRecord;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum RecordFilters {
    LOAD_AVG_1MIN("Load Avg. (1min)", SysinfoRecord.class, record -> record.load1),
    SWAP_PAGE_IN("Page Swap In", SysinfoRecord.class, record -> record.delta_swapPageIn),
    SWAP_PAGE_IN_GT_0("Page Swap In > 0", SysinfoRecord.class, record -> record.delta_swapPageIn > 0L, record -> record.delta_swapPageIn),
    SWAP_PAGE_OUT("Page Swap Out", SysinfoRecord.class, record -> record.delta_swapPageOut),
    SWAP_PAGE_OUT_GT_0("Page Swap Out > 0", SysinfoRecord.class, record -> record.delta_swapPageOut > 0L, record -> record.delta_swapPageOut),
    CG_THROTTLED_TIME("Throttled Time", SysinfoRecord.class, record -> record.cg_cpu_throttle_throttled_ms),
    NEW_GC_DURATION("New GC Duration", GCRecord.class, GCRecord::isNew, record -> record.intra_seconds),
    OLD_GC_DURATION("Old GC Duration", GCRecord.class, GCRecord::isOld, record -> record.intra_seconds),
    GC_TIME_PERCENT("GC Time %", GCRecord.class, record -> record.intra_seconds / (record.inter_seconds + record.intra_seconds) * 100.0),
    APP_THREADS("Application Threads", GCRecord.class, record -> record.threads),
    ALLOC_DELAY("Allocation Delay/Stalls > 0", GCRecord.class, record -> record.isNew() && record.max_thread_delay > 0.0, record -> record.max_thread_delay),
    NEW_GEN_LIVESET("NewGen LiveSet", GCRecord.class, GCRecord::isNew, record -> record.gen_live),
    OLD_GEN_LIVESET("OldGen LiveSet", GCRecord.class, GCRecord::isOld, record -> record.gen_live),
    VMA_COUNTS("VMA Counts", VmaCountersRecord.class, record -> record.vmaCount),
    VMA_GREATER_THAN_50PCT("VMA Counts > 50% upper limit", VmaCountersRecord.class, record -> (double)record.vmaCount >= 0.5 * (double)record.vmaMax, record -> record.vmaCount),
    DEOPT_PAUSE_OP_TIME("Depotimize Pause Time", SafepointRecord.class, record -> record.op_name_label.equals("Deoptimize Pause"), record -> record.op_ms),
    HUGE_PAGE_COMPACTION_STALLS("Huge Page Compaction Stalls", HugePageStatRecord.class, record -> record.compact_stall > 0L, record -> record.compact_stall);

    private final String name;
    private final Class<? extends LogRecord> recordClass;
    private final Predicate<LogRecord> filter;
    private final Function<LogRecord, Double> mapper;

    private <T extends LogRecord> RecordFilters(String name, Class<T> klass, Predicate<T> filter, Function<T, Double> mapper) {
        this.name = name;
        this.recordClass = klass;
        this.filter = filter;
        this.mapper = mapper;
    }

    private <T extends LogRecord> RecordFilters(String name, Class<T> klass, Function<T, Double> mapper) {
        this(name, klass, record -> true, mapper);
    }

    List<Double> getValues(LogModel model) {
        return Utils.getLogRecordsAsStream(model, this.recordClass).filter(this.filter).map(this.mapper).collect(Collectors.toList());
    }

    final <T extends LogRecord> List<Double> getValues(LogModel model, Predicate<T> additionalFilter) {
        return Utils.getLogRecordsAsStream(model, this.recordClass).filter(this.filter).filter(additionalFilter).map(this.mapper).collect(Collectors.toList());
    }

    <T extends LogRecord> List<T> getRecords(LogModel model) {
        return Utils.getLogRecordsAsStream(model, this.recordClass).filter(this.filter).collect(Collectors.toList());
    }

    <T extends LogRecord> List<T> getRecords(LogModel model, Predicate<T> additionalFilter) {
        return Utils.getLogRecordsAsStream(model, this.recordClass).filter(this.filter).filter(additionalFilter).collect(Collectors.toList());
    }

    List<Double> getValuesInVisibleRange(LogModel model, long rangeStart, long rangeEnd) {
        return Utils.getLogRecordsInGivenRangeAsStream(model, this.recordClass, rangeStart, rangeEnd).filter(this.filter).map(this.mapper).collect(Collectors.toList());
    }

    final <T extends LogRecord> List<Double> getValuesInVisibleRange(LogModel model, Predicate<T> additionalFilter, long rangeStart, long rangeEnd) {
        return Utils.getLogRecordsInGivenRangeAsStream(model, this.recordClass, rangeStart, rangeEnd).filter(this.filter).filter(additionalFilter).map(this.mapper).collect(Collectors.toList());
    }

    <T extends LogRecord> List<T> getRecordsInVisibleRange(LogModel model, long rangeStart, long rangeEnd) {
        return Utils.getLogRecordsInGivenRangeAsStream(model, this.recordClass, rangeStart, rangeEnd).filter(this.filter).collect(Collectors.toList());
    }

    <T extends LogRecord> List<T> getRecordsInVisibleRange(LogModel model, Predicate<T> additionalFilter, long rangeStart, long rangeEnd) {
        return Utils.getLogRecordsInGivenRangeAsStream(model, this.recordClass, rangeStart, rangeEnd).filter(this.filter).filter(additionalFilter).collect(Collectors.toList());
    }
}

