/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.advisor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StatsProvider {
    double min;
    double max;
    double totalCount;
    boolean isShowingUpTrend;
    boolean isShowingDownTrend;
    boolean isShowingSharpRise;

    private StatsProvider() {
    }

    public static StatsProvider getStats(List<Double> data) {
        StatsProvider stats = new StatsProvider();
        stats.max = data.size() == 0 ? -1.0 : Collections.max(data);
        stats.min = data.size() == 0 ? -1.0 : Collections.min(data);
        stats.totalCount = data.size();
        stats.isShowingUpTrend = stats.isShowingUptrend(data);
        stats.isShowingDownTrend = stats.isShowingDowntrend(data);
        stats.isShowingSharpRise = stats.isShowingSharpRise(data);
        return stats;
    }

    private double bestApproximateSlope(List<Double> x, List<Double> y) {
        int n = x.size();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        for (int i = 0; i < n; ++i) {
            sumX += x.get(i).doubleValue();
            sumY += y.get(i).doubleValue();
            sumXY += x.get(i) * y.get(i);
            sumX2 += Math.pow(x.get(i), 2.0);
        }
        double m = ((double)n * sumXY - sumX * sumY) / ((double)n * sumX2 - Math.pow(sumX, 2.0));
        return m;
    }

    private double bestApproximateSlope(List<Double> y) {
        List<Double> x = IntStream.range(0, y.size()).mapToDouble(val -> val).boxed().collect(Collectors.toList());
        return this.bestApproximateSlope(x, y);
    }

    private boolean isShowingUptrend(List<Double> x, List<Double> y) {
        return this.bestApproximateSlope(x, y) > 0.0;
    }

    private boolean isShowingDowntrend(List<Double> x, List<Double> y) {
        return this.bestApproximateSlope(x, y) < 0.0;
    }

    private boolean isShowingUptrend(List<Double> y) {
        return this.bestApproximateSlope(y) > 0.0;
    }

    private boolean isShowingDowntrend(List<Double> y) {
        return this.bestApproximateSlope(y) < 0.0;
    }

    private boolean isShowingSharpRise(List<Double> y) {
        if (!this.isShowingUptrend(y)) {
            return false;
        }
        return this.max / this.min > 1.5;
    }
}

