/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.advisor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class VMFlagsDependencyInfo {
    private final List<String> vmFlagsOnCmdLine;

    private VMFlagsDependencyInfo(List<String> vmFlagsOnCmdLine) {
        this.vmFlagsOnCmdLine = vmFlagsOnCmdLine;
    }

    public static VMFlagsDependencyInfo create(String vmFlagsOnCommandLine) {
        List<String> jvmArgumentsList = vmFlagsOnCommandLine == null || vmFlagsOnCommandLine.trim().isEmpty() ? Collections.emptyList() : VMFlagsDependencyInfo.fetchVMArugumentsAsList(vmFlagsOnCommandLine);
        return new VMFlagsDependencyInfo(jvmArgumentsList);
    }

    private static List<String> fetchVMArugumentsAsList(String vmFlags) {
        return Arrays.stream((" " + vmFlags.trim()).split(" +-(?!\\d)")).map(flag -> "-" + flag).map(flag -> flag.replaceAll("=.*", "=")).filter(flag -> flag.startsWith("-X")).collect(Collectors.toList());
    }

    public List<String> getVMFlagsOnCmdLineAsList() {
        return Collections.unmodifiableList(this.vmFlagsOnCmdLine);
    }

    private List<String> getDependentFlags(String inputVMFlag) {
        return VMFlagKnowledgeBase.getDependentsOf(inputVMFlag).stream().collect(Collectors.toUnmodifiableList());
    }

    public List<String> getMissingDependentsFor(String inputVMFlag) {
        List<String> missingDependentList = this.getDependentFlags(inputVMFlag).stream().filter(Predicate.not(this.vmFlagsOnCmdLine::contains)).collect(Collectors.toUnmodifiableList());
        if (missingDependentList.isEmpty()) {
            return missingDependentList;
        }
        return missingDependentList.stream().filter(Predicate.not(this::isInputVMFlagOrItsAliasPresentOnCommandLine)).collect(Collectors.toUnmodifiableList());
    }

    private boolean isInputVMFlagOrItsAliasPresentOnCommandLine(String inputVMFlag) {
        return this.vmFlagsOnCmdLine.stream().anyMatch(cmdFlag -> VMFlagKnowledgeBase.getAliasOf(inputVMFlag).contains(cmdFlag));
    }

    static final class VMFlagKnowledgeBase {
        private static final Map<String, List<String>> VM_FLAG_DEPENDENTS = Map.of("-XX:CompilerTier2BudgetingCPUPercent=", List.of("-XX:+EnableTier2CompilerBudgeting"), "-XX:CompilerTier2BudgetingWarmupCPUPercent=", List.of("-XX:+EnableTier2CompilerBudgeting"), "-XX:CompilerTier2BudgetWindowDurationMs=", List.of("-XX:+EnableTier2CompilerBudgeting"), "-XX:CompilerWarmupPeriodSeconds=", List.of("-XX:CompilerWarmupExtraThreads=", "-XX:CompilerTier2BudgetingWarmupCPUPercent="));
        private static final Map<String, List<String>> VM_FLAG_ALIAS = Map.of();

        private VMFlagKnowledgeBase() {
        }

        public static List<String> getAliasOf(String inputVMFlag) {
            return Collections.unmodifiableList(VM_FLAG_ALIAS.getOrDefault(inputVMFlag, Collections.emptyList()));
        }

        public static List<String> getDependentsOf(String inputVMFlag) {
            return Collections.unmodifiableList(VM_FLAG_DEPENDENTS.getOrDefault(inputVMFlag, Collections.emptyList()));
        }
    }
}

