/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.advisor.utils;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.advisor.LogLineInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Utils {
    public static Optional<Integer> getInt(Map<String, LogLineInfo> map, String key) {
        LogLineInfo val = map.get(key);
        return val == null ? Optional.empty() : Optional.of(Integer.parseInt(val.value));
    }

    public static Optional<String> getString(Map<String, LogLineInfo> map, String key) {
        LogLineInfo val = map.get(key);
        return val == null ? Optional.empty() : Optional.of(val.value);
    }

    public static Optional<List<String>> getStringList(Map<String, LogLineInfo> map, String key) {
        LogLineInfo val = map.get(key);
        return val == null ? Optional.empty() : Optional.of(Arrays.asList(val.value.trim().split("\\s+")));
    }

    public static Optional<List<String>> getAlphaNumericStringList(Map<String, LogLineInfo> map, String key) {
        LogLineInfo val = map.get(key);
        return val == null ? Optional.empty() : Optional.of(Arrays.stream(val.value.trim().split("\\s+")).map(string -> string.replaceAll("[^a-zA-Z0-9]", "")).collect(Collectors.toList()));
    }

    public static <T extends LogRecord> Stream<T> getLogRecordsAsStream(LogModel logModel, Class<T> klass) {
        return StreamSupport.stream(logModel.getRecordsMap().getRecords(klass, null, null, null, null).spliterator(), false);
    }

    public static <T extends LogRecord> Stream<T> getLogRecordsInGivenRangeAsStream(LogModel logModel, Class<T> klass, long rangeStart, long rangeEnd) {
        return Utils.getLogRecordsAsStream(logModel, klass).filter(record -> {
            double recordRelativeTimestamp = record.getEventRelativeTimestamp(TimeUnit.SECONDS);
            return recordRelativeTimestamp >= (double)rangeStart && recordRelativeTimestamp <= (double)rangeEnd;
        });
    }

    public static List<LogRecord> getLogRecordsAsStdList(LogModel logModel, Class<? extends LogRecord> klass) {
        return Utils.getLogRecordsAsStream(logModel, klass).collect(Collectors.toList());
    }

    public static double getLogRecordTimeStampInSeconds(LogRecord logRecord) {
        return logRecord.getEventRelativeTimestamp().getInUnits(LogUnits.SECONDS);
    }

    public static double getAvgEventFrequencyGivenLogRecords(List<? extends LogRecord> logRecords) {
        List<Long> elapsedTimesOfLogRecords = logRecords.stream().map(LogRecord::getEventRelativeTimestamp).map(relativeTimestamp -> relativeTimestamp.getInUnits(TimeUnit.SECONDS)).collect(Collectors.toList());
        return Utils.getAvgEventFrequencyGivenElapsedTimes(elapsedTimesOfLogRecords);
    }

    public static double getAvgEventFrequencyGivenElapsedTimes(List<Long> elapsedTimeOfSuccessiveEvents) {
        ArrayList<Long> tmpList = new ArrayList<Long>();
        for (int i = 1; i < elapsedTimeOfSuccessiveEvents.size(); ++i) {
            tmpList.add(elapsedTimeOfSuccessiveEvents.get(i) - elapsedTimeOfSuccessiveEvents.get(i - 1));
        }
        return Math.round(tmpList.stream().mapToDouble(d -> d.longValue()).average().orElse(Double.MAX_VALUE));
    }
}

