/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="CCFH", data_marker="CCF")
@C4_FieldsDescription(file="c4/CodeCacheFlushingRecord")
public final class CodeCacheFlushingRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="queuedForFlush", defaultUnits=LogUnits.CODEBLOBS)
    public int made_not_entrant;
    @C4_GCLogRecordField(header="queuedForFlushSize", defaultUnits=LogUnits.BYTES)
    public long made_not_entrant_size_in_bytes;
    @C4_GCLogRecordField(header="flushed", defaultUnits=LogUnits.CODEBLOBS)
    public int flushed;
    @C4_GCLogRecordField(header="flushedSize", defaultUnits=LogUnits.BYTES)
    public long flushed_size_in_bytes;
    @C4_GCLogRecordField(header="freedTotal", defaultUnits=LogUnits.CODEBLOBS)
    public int freed_total;
    @C4_GCLogRecordField(header="freedTotalSize", defaultUnits=LogUnits.BYTES)
    public long freed_total_size_in_bytes;
    @C4_GCLogRecordField(header="bytesAllTypes", defaultUnits=LogUnits.BYTES)
    public int used_all_types;
    @C4_GCLogRecordField(header="c2i2cAdapters", defaultUnits=LogUnits.CODEBLOBS)
    public int c2i_adapters;
    @C4_GCLogRecordField(header="c2i2cAdaptersBytes", defaultUnits=LogUnits.BYTES)
    public long c2i_adapters_size_in_bytes;
    @C4_GCLogRecordField(header="methodStubs", defaultUnits=LogUnits.CODEBLOBS)
    public int methodstubs;
    @C4_GCLogRecordField(header="methodStubsBytes", defaultUnits=LogUnits.BYTES)
    public long methodstubs_size_in_bytes;
    @C4_GCLogRecordField(header="nativeWrappers", defaultUnits=LogUnits.CODEBLOBS)
    public int native_wrappers;
    @C4_GCLogRecordField(header="nativeWrappersBytes", defaultUnits=LogUnits.BYTES)
    public long native_wrappers_size_in_bytes;
    @C4_GCLogRecordField(header="tier1Compiles", defaultUnits=LogUnits.CODEBLOBS)
    public int c1_compiles;
    @C4_GCLogRecordField(header="tier1CompilesBytes", defaultUnits=LogUnits.BYTES)
    public long c1_compiles_size_in_bytes;
    @C4_GCLogRecordField(header="tier2Compiles", defaultUnits=LogUnits.CODEBLOBS)
    public int c2_compiles;
    @C4_GCLogRecordField(header="tier2CompilesBytes", defaultUnits=LogUnits.BYTES)
    public long c2_compiles_size_in_bytes;
    @C4_GCLogRecordField(header="objMonitors", defaultUnits=LogUnits.CODEBLOBS)
    public int monitors;
    @C4_GCLogRecordField(header="objMonitorsBytes", defaultUnits=LogUnits.BYTES)
    public long monitors_size_in_bytes;
    @C4_GCLogRecordField(header="vtables", defaultUnits=LogUnits.CODEBLOBS)
    public int vtablestubs;
    @C4_GCLogRecordField(header="vtablesBytes", defaultUnits=LogUnits.BYTES)
    public long vtablestubs_size_in_bytes;
    @C4_GCLogRecordField(header="mhAdapters", defaultUnits=LogUnits.CODEBLOBS)
    public int mh_adapters;
    @C4_GCLogRecordField(header="mhAdaptersBytes", defaultUnits=LogUnits.BYTES)
    public long mh_adapters_size_in_bytes;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s = -1.0;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        if (this.end_s != -1.0) {
            return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
        }
        return super.getEventRelativeTimestampEx();
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<CodeCacheFlushingRecord> {
        public Parser() {
            super(CodeCacheFlushingRecord.class);
        }
    }
}

