/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="MALLINFOH", data_marker="MALLINFO")
@C4_FieldsDescription(file="c4/MallocInfoRecord")
public final class MallocInfoRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="mallinfoArena", defaultUnits=LogUnits.BYTES)
    public long arena;
    @C4_GCLogRecordField(header="mallinfoOrdblks", defaultUnits=LogUnits.COUNT)
    public long ordblks;
    @C4_GCLogRecordField(header="mallinfoSmblks", defaultUnits=LogUnits.COUNT)
    public long smblks;
    @C4_GCLogRecordField(header="mallinfoHblks", defaultUnits=LogUnits.COUNT)
    public long hblks;
    @C4_GCLogRecordField(header="mallinfoHblkhd", defaultUnits=LogUnits.BYTES)
    public long hblkhd;
    @C4_GCLogRecordField(header="mallinfoUsmblks", defaultUnits=LogUnits.BYTES)
    public long usmblks;
    @C4_GCLogRecordField(header="mallinfoFsmblks", defaultUnits=LogUnits.BYTES)
    public long fsmblks;
    @C4_GCLogRecordField(header="mallinfoUordblks", defaultUnits=LogUnits.BYTES)
    public long uordblks;
    @C4_GCLogRecordField(header="mallinfoFordblks", defaultUnits=LogUnits.BYTES)
    public long fordblks;
    @C4_GCLogRecordField(header="mallinfoKeepcost", defaultUnits=LogUnits.BYTES)
    public long keepcost;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;
    @LogRecordCalculatedField(defaultUnits=LogUnits.BYTES, deps={"hblkhd", "uordblks"})
    public double mallocLiveSet;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<MallocInfoRecord> {
        public Parser() {
            super(MallocInfoRecord.class);
        }

        @Override
        public Collection<String> getPrefixes() {
            return Arrays.asList("MALLINFOH", "MALLINFO2H", "MALLINFO", "MALLINFO2");
        }

        @Override
        public C4_LogLineParser.DataLineParseResult parseDataLine(C4_ParserState state, C4_LogParser.DataLine dataLine) throws ParserException {
            switch (dataLine.prefix) {
                case "MALLINFOH": 
                case "MALLINFO2H": {
                    if (this.parseHeaderImpl(dataLine.data)) {
                        return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
                    }
                }
                case "MALLINFO": 
                case "MALLINFO2": {
                    return this.parseDataLineImpl(state, dataLine);
                }
            }
            throw new AssertionError();
        }

        @Override
        protected void computeCalculatedFields(MallocInfoRecord record) throws ParserException {
            record.mallocLiveSet = record.hblkhd + record.uordblks;
        }
    }
}

