/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="PRECOMPSTATSH", data_marker="PRECOMPSTATS")
@C4_FieldsDescription(file="c4/PrecompstatsRecord")
public final class PrecompstatsRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="Tier")
    public int tier;
    @C4_GCLogRecordField(header="EligibleMethods", defaultUnits=LogUnits.METHODS)
    public long eligibleMethods;
    @C4_GCLogRecordField(header="TriggeredCompiles", defaultUnits=LogUnits.COUNT)
    public long triggeredCompiles;
    @C4_GCLogRecordField(header="PremainTriggered", defaultUnits=LogUnits.COUNT)
    public long premainTriggered;
    @C4_GCLogRecordField(header="CompiledMethods", defaultUnits=LogUnits.METHODS)
    public long compiledMethods;
    @C4_GCLogRecordField(header="PrecompiledMethods", defaultUnits=LogUnits.METHODS)
    public long precompiledMethods;
    @C4_GCLogRecordField(header="PrecompileTarget", defaultUnits=LogUnits.METHODS)
    public long precompileTarget;
    @C4_GCLogRecordField(header="LateTriggered", defaultUnits=LogUnits.COUNT)
    public long lateTriggered;
    @C4_GCLogRecordField(header="BufferedCompiles", defaultUnits=LogUnits.COUNT)
    public long bufferedCompiles;
    @C4_GCLogRecordField(header="FailedInstalls", defaultUnits=LogUnits.COUNT)
    public long failedInstalls;
    @C4_GCLogRecordField(header="InvalidDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long invalidDependencyMethods;
    @C4_GCLogRecordField(header="UnsatisfiableDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long unsatisfiableDependencyMethods;
    @C4_GCLogRecordField(header="CollidingDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long collidingDependencyMethods;
    @C4_GCLogRecordField(header="GeneratedDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long generatedDependencyMethods;
    @C4_GCLogRecordField(header="NoPrecompiledDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long noPrecompiledDependencyMethods;
    @C4_GCLogRecordField(header="NoPreloadDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long noPreloadDependencyMethods;
    @C4_GCLogRecordField(header="NoPreinitializationDependencyMethods", defaultUnits=LogUnits.METHODS)
    public long noPreinitializationDependencyMethods;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s = -1.0;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        if (this.end_s != -1.0) {
            return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
        }
        return super.getEventRelativeTimestampEx();
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<PrecompstatsRecord> {
        public Parser() {
            super(PrecompstatsRecord.class);
        }

        @Override
        protected String getFallbackHeader() {
            return "[PRECOMPSTATSH Tier : EligibleMethods TriggeredCompiles PremainTriggered CompiledMethods PrecompiledMethods PrecompileTarget LateTriggered BufferedCompiles FailedInstalls FailedTriggers InvalidDependencyMethods UnsatisfiableDependencyMethods UnsatisfiableLoadDependencyMethods FixedUnsatisfiableLoadDependencyMethods UnsatisfiableLinkDependencyMethods FixedUnsatisfiableLinkDependencyMethods UnsatisfiableInitDependencyMethods FixedUnsatisfiableInitDependencyMethods CollidingDependencyMethods GeneratedDependencyMethods NoPrecompiledDependencyMethods NoPreloadDependencyMethods NoPreinitializationDependencyMethods]";
        }
    }
}

