/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class C4_LogFilesSupport {
    private C4_LogFilesSupport() {
    }

    private static long extract(String string, String mark) {
        int idx2;
        int idx1 = string.indexOf(mark);
        if (idx1 < 0 || (idx1 = string.indexOf(58, idx1 + mark.length())) < 0 || (idx2 = string.lastIndexOf(93)) < 0) {
            return -1L;
        }
        return Long.decode(string.substring(idx1 + 1, idx2).trim());
    }

    public static List<C4_GCLogFile> findGCLogFiles(Path logFilePath) {
        if (Files.isDirectory(logFilePath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile("(.*)\\.[0-9]+(\\.current)*$");
        ArrayList<C4_GCLogFile> gcLogFiles = new ArrayList<C4_GCLogFile>();
        C4_GCLogFile gcLogFile = C4_GCLogFile.get(logFilePath);
        gcLogFiles.add(gcLogFile);
        String logName = logFilePath.getFileName().toString();
        Matcher matcher = p.matcher(logName);
        if (matcher.matches()) {
            logName = matcher.group(1);
        }
        long vmStartTime = gcLogFile.vmStartTime;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(logFilePath.getParent());){
            for (Path path : ds) {
                if (path.equals(logFilePath) || !path.getFileName().toString().startsWith(logName) || (gcLogFile = C4_GCLogFile.get(path)) == null || vmStartTime != gcLogFile.vmStartTime) continue;
                gcLogFiles.add(gcLogFile);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(C4_LogFilesSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        gcLogFiles.sort(Comparator.comparingInt(f -> f.sequenceNumber));
        return Collections.unmodifiableList(gcLogFiles);
    }

    public static InputStream newInputStream(List<C4_GCLogFile> logs) throws IOException {
        if (logs.size() == 1) {
            return Files.newInputStream(logs.get(0).getPath(), new OpenOption[0]);
        }
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (C4_GCLogFile log : logs) {
            streams.add(Files.newInputStream(log.getPath(), new OpenOption[0]));
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static long getSize(List<C4_GCLogFile> logs) throws IOException {
        long size = 0L;
        for (C4_GCLogFile log : logs) {
            size += Files.size(log.getPath());
        }
        return size;
    }

    public static String getGCLogName(List<C4_GCLogFile> gcLogFiles) {
        String firstFileName = gcLogFiles.get(0).getPath().getFileName().toString();
        if (gcLogFiles.size() == 1) {
            return firstFileName;
        }
        Pattern p = Pattern.compile("(.*)\\.[0-9]+(\\.current)*$");
        Matcher m = p.matcher(firstFileName);
        StringBuilder name = new StringBuilder();
        name.append(m.matches() ? m.group(1) : firstFileName);
        StringJoiner parts = new StringJoiner(", ");
        gcLogFiles.stream().map(f -> Integer.toString(f.getSequenceNumber())).forEach(parts::add);
        name.append(" [Sequences: ").append(parts).append("]");
        return name.toString();
    }

    public static final class C4_GCLogFile {
        private static final String sequenceMark = "[GCHH : sequence no.";
        private static final String vmStartTimeMark = "[GCHH : start time ms";
        private final Path path;
        private final long vmStartTime;
        private final int sequenceNumber;

        private C4_GCLogFile(Path path, long vmStartTime, int sequence) {
            this.path = path;
            this.vmStartTime = vmStartTime;
            this.sequenceNumber = sequence;
        }

        public Path getPath() {
            return this.path;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static C4_GCLogFile get(Path file) {
            try (BufferedReader br = Files.newBufferedReader(file, Charset.defaultCharset());){
                int maxLines = 50;
                int sequence = -1;
                long vmStartTime = -1L;
                do {
                    if (maxLines-- <= 0) return new C4_GCLogFile(file, 0L, 0);
                    String s = br.readLine();
                    if (s == null) return new C4_GCLogFile(file, 0L, 0);
                    if (sequence < 0) {
                        sequence = (int)C4_LogFilesSupport.extract(s, sequenceMark);
                    }
                    if (vmStartTime >= 0L) continue;
                    vmStartTime = C4_LogFilesSupport.extract(s, vmStartTimeMark);
                } while (sequence < 0 || vmStartTime <= 0L);
                C4_GCLogFile c4_GCLogFile = new C4_GCLogFile(file, vmStartTime, sequence);
                return c4_GCLogFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new C4_GCLogFile(file, 0L, 0);
        }
    }

    public static final class GCLogLocationInfo {
        private final C4_GCLogFile file;
        private final int lineInFile;

        GCLogLocationInfo(C4_GCLogFile file, int lineInFile) {
            this.file = file;
            this.lineInFile = lineInFile;
        }

        public C4_GCLogFile getGCLogFile() {
            return this.file;
        }

        public int getLineInFile() {
            return this.lineInFile;
        }
    }
}

