/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.nmt;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.nmt.JVM_Part;
import com.azul.log.parser.impl.nmt.NMT_LogLineParserImpl;
import com.azul.log.parser.impl.nmt.NMT_ParserState;
import com.azul.log.parser.impl.nmt.NMT_Summary;
import com.azul.log.parser.impl.nmt.State;
import com.azul.log.parser.impl.nmt.records.NMT_LogRecord;
import com.azul.log.parser.impl.nmt.records.NMT_MallocRecord;
import com.azul.log.parser.impl.nmt.records.NMT_MmapCommittedRecord;
import com.azul.log.parser.impl.nmt.records.NMT_MmapRecord;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NMT_LogParser
extends LogParserImpl<NMT_ParserState> {
    private final SummarySupport summarySupport;
    private final NMT_Summary summary = new NMT_Summary();

    public NMT_LogParser(LogModel model) {
        super(model, new NMT_ParserState());
        this.summarySupport = this.initSummarySupport();
        this.ic.add(this.summary);
    }

    private SummarySupport initSummarySupport() {
        SummarySupport ss = new SummarySupport(l -> ((NMT_ParserState)this.state).getCurrentLineNumber() > 100);
        ss.addExtractor(l -> {
            if (((NMT_ParserState)this.state).getJvmPart() == JVM_Part.TOTAL) {
                String snippet = "";
                String record = "";
                if (this.summary.totalMem == null) {
                    snippet = l.subSequence(7, 11).toString();
                    record = l.subSequence(7, l.length()).toString();
                } else if (l.length() >= 4) {
                    snippet = l.subSequence(0, 4).toString();
                    record = l.subSequence(0, l.length()).toString();
                }
                switch (snippet) {
                    case "rese": {
                        this.summary.totalMem = record;
                        break;
                    }
                    case "mall": {
                        this.summary.totalMalloc = record;
                        break;
                    }
                    case "mmap": {
                        this.summary.totalMmap = record;
                    }
                }
            }
            int start = TextUtils.indexOf(l, '(', 0) + 1;
            if (((NMT_ParserState)this.state).getJvmPart() != JVM_Part.UNDEFINED && start >= 0) {
                String snippet = l.subSequence(start, start + 4 > l.length() ? start : start + 4).toString();
                String record = l.subSequence(start, l.length() - 1).toString().replaceAll("[()]", "");
                if (snippet.equals("rese")) {
                    switch (((NMT_ParserState)this.state).getJvmPart()) {
                        case HEAP: {
                            this.summary.heapMem = record;
                            break;
                        }
                        case CLASS: {
                            this.summary.classMem = record;
                            break;
                        }
                        case THREAD: {
                            this.summary.threadMem = record;
                            break;
                        }
                        case CODE: {
                            this.summary.codeMem = record;
                            break;
                        }
                        case GC: {
                            this.summary.gcMem = record;
                            break;
                        }
                        case COMPILER: {
                            this.summary.compilerMem = record;
                            break;
                        }
                        case COMPILER_RUNTIME: {
                            this.summary.compilerRunMem = record;
                            break;
                        }
                        case INTERNAL: {
                            this.summary.internalMem = record;
                            break;
                        }
                        case OTHER: {
                            this.summary.otherMem = record;
                            break;
                        }
                        case SYMBOL: {
                            this.summary.symbolMem = record;
                            break;
                        }
                        case NMT: {
                            this.summary.nmtMem = record;
                            break;
                        }
                        case ARENA: {
                            this.summary.arenaMem = record;
                            break;
                        }
                        case TRACING: {
                            this.summary.tracingMem = record;
                            break;
                        }
                        case LOGGING: {
                            this.summary.loggingMem = record;
                            break;
                        }
                        case ARGUMENTS: {
                            this.summary.argumentsMem = record;
                            break;
                        }
                        case MODULE: {
                            this.summary.moduleMem = record;
                            break;
                        }
                        case SYNCHRONIZATION: {
                            this.summary.syncMem = record;
                        }
                    }
                } else if (snippet.equals("mmap")) {
                    switch (((NMT_ParserState)this.state).getJvmPart()) {
                        case HEAP: {
                            this.summary.heapMmap = record;
                            break;
                        }
                        case CLASS: {
                            this.summary.classMmap = record;
                            break;
                        }
                        case CODE: {
                            this.summary.codeMmap = record;
                            break;
                        }
                        case GC: {
                            this.summary.gcMmap = record;
                            break;
                        }
                        case INTERNAL: {
                            this.summary.internalMmap = record;
                        }
                    }
                } else if (snippet.equals("clas")) {
                    this.summary.classNum = record;
                } else if (snippet.equals("  in") || snippet.equals("inst")) {
                    this.summary.classData = record;
                } else if (snippet.equals("thre")) {
                    this.summary.threadNum = record;
                } else if (snippet.equals("stac")) {
                    this.summary.threadStack = record;
                } else if (snippet.equals("trac")) {
                    this.summary.nmtOverhead = record;
                } else if (snippet.equals("mall")) {
                    switch (((NMT_ParserState)this.state).getJvmPart()) {
                        case CLASS: {
                            this.summary.classMalloc = record;
                            break;
                        }
                        case THREAD: {
                            this.summary.threadMalloc = record;
                            break;
                        }
                        case CODE: {
                            this.summary.codeMalloc = record;
                            break;
                        }
                        case GC: {
                            this.summary.gcMalloc = record;
                            break;
                        }
                        case COMPILER: {
                            this.summary.compilerMalloc = record;
                            break;
                        }
                        case COMPILER_RUNTIME: {
                            this.summary.compilerRunMalloc = record;
                            break;
                        }
                        case INTERNAL: {
                            this.summary.internalMalloc = record;
                            break;
                        }
                        case OTHER: {
                            this.summary.otherMalloc = record;
                            break;
                        }
                        case SYMBOL: {
                            this.summary.symbolMalloc = record;
                            break;
                        }
                        case NMT: {
                            this.summary.nmtMalloc = record;
                            break;
                        }
                        case ARENA: {
                            this.summary.arenaMalloc = record;
                            break;
                        }
                        case TRACING: {
                            this.summary.tracingMalloc = record;
                            break;
                        }
                        case LOGGING: {
                            this.summary.loggingMalloc = record;
                            break;
                        }
                        case ARGUMENTS: {
                            this.summary.argumentsMalloc = record;
                            break;
                        }
                        case MODULE: {
                            this.summary.moduleMalloc = record;
                            break;
                        }
                        case SYNCHRONIZATION: {
                            this.summary.syncMalloc = record;
                        }
                    }
                } else if (snippet.equals("aren")) {
                    switch (((NMT_ParserState)this.state).getJvmPart()) {
                        case THREAD: {
                            this.summary.threadArena = record;
                            break;
                        }
                        case COMPILER: {
                            this.summary.compilerArena = record;
                            break;
                        }
                        case SYMBOL: {
                            this.summary.symbolArena = record;
                        }
                    }
                }
            }
            return false;
        });
        return ss;
    }

    @Override
    protected LogLineWithTime parseLogLineImpl(CharSequence line) throws ParserException {
        if (TextUtils.startsWith(line, "Total:")) {
            ((NMT_ParserState)this.state).setJvmPart(JVM_Part.TOTAL);
        } else if (TextUtils.startsWith(line, "-")) {
            int start_ind = 1;
            while (line.charAt(start_ind) == ' ') {
                ++start_ind;
            }
            int end_ind = start_ind;
            while (line.charAt(end_ind) != '(') {
                ++end_ind;
            }
            ((NMT_ParserState)this.state).setJvmPart(JVM_Part.getEnumEntry(line.subSequence(start_ind, --end_ind).toString()));
        }
        if (line.length() > 0 && ((NMT_ParserState)this.state).getState() == State.SUMMARY) {
            this.summarySupport.process(line);
        }
        return new LogLineWithTime(line);
    }

    @Override
    protected List<? extends LogRecord> getLogRecordsImpl(String data) throws ParserException {
        List<String> logTokens = this.getTokens(data);
        ArrayList<NMT_LogRecord> records = new ArrayList<NMT_LogRecord>();
        boolean gotFullRecord = false;
        if (logTokens != null) {
            switch (((NMT_ParserState)this.state).getState()) {
                case MMAP_RESERVED: 
                case MMAP_BOTH: {
                    if (((NMT_ParserState)this.state).getLastRecord() != null) {
                        records.add(((NMT_ParserState)this.state).getLastRecord());
                        ((NMT_ParserState)this.state).setLastRecord(null);
                        ((NMT_ParserState)this.state).setLastCommited(null);
                        gotFullRecord = true;
                    }
                    ((NMT_ParserState)this.state).setLastRecord(new NMT_MmapRecord());
                    if (((NMT_ParserState)this.state).getState() == State.MMAP_RESERVED) {
                        NMT_LogLineParserImpl<NMT_MmapRecord> logLineParser = new NMT_LogLineParserImpl<NMT_MmapRecord>(NMT_MmapRecord.class);
                        NMT_LogRecord result = logLineParser.parseLine(logTokens);
                        if (result == null) break;
                        ((NMT_ParserState)this.state).setLastRecord(result);
                        break;
                    }
                    NMT_LogLineParserImpl<NMT_LogRecord> logLineParser = new NMT_LogLineParserImpl<NMT_MmapRecord>(NMT_MmapRecord.class);
                    NMT_LogRecord result = logLineParser.parseLine(logTokens);
                    if (result != null) {
                        ((NMT_ParserState)this.state).setLastRecord(result);
                    }
                    if ((result = (logLineParser = new NMT_LogLineParserImpl<NMT_MmapCommittedRecord>(NMT_MmapCommittedRecord.class)).parseLine(logTokens.subList(0, 2))) == null) break;
                    ((NMT_ParserState)this.state).setLastCommited(result);
                    ((NMT_ParserState)this.state).getLastRecord().updateField("committed", ((NMT_ParserState)this.state).getLastCommited());
                    break;
                }
                case MMAP_COMMITED: {
                    NMT_LogLineParserImpl<NMT_MmapCommittedRecord> logLineParser = new NMT_LogLineParserImpl<NMT_MmapCommittedRecord>(NMT_MmapCommittedRecord.class);
                    NMT_LogRecord result = logLineParser.parseLine(logTokens);
                    if (result == null) break;
                    ((NMT_ParserState)this.state).setLastCommited(result);
                    ((NMT_ParserState)this.state).getLastRecord().updateField("committed", ((NMT_ParserState)this.state).getLastCommited());
                    break;
                }
                case MMAP_RESERVED_STACK: {
                    ((NMT_ParserState)this.state).getLastRecord().updateField("reserved stack", logTokens.get(0));
                    break;
                }
                case MMAP_COMMITED_STACK: {
                    ((NMT_ParserState)this.state).getLastCommited().updateField("committed stack", logTokens.get(0));
                    break;
                }
                case MMAP_BOTH_STACK: {
                    ((NMT_ParserState)this.state).getLastRecord().updateField("reserved stack", logTokens.get(0));
                    ((NMT_ParserState)this.state).getLastCommited().updateField("committed stack", logTokens.get(0));
                    break;
                }
                case DETAILS: {
                    if (((NMT_ParserState)this.state).getLastRecord() == null) break;
                    records.add(((NMT_ParserState)this.state).getLastRecord());
                    ((NMT_ParserState)this.state).setLastRecord(null);
                    ((NMT_ParserState)this.state).setLastCommited(null);
                    gotFullRecord = true;
                    break;
                }
                case MALLOC_STACK: {
                    ((NMT_ParserState)this.state).addMalloc(logTokens.get(0));
                    break;
                }
                case MALLOC_END: {
                    NMT_LogLineParserImpl<NMT_MallocRecord> logLineParser = new NMT_LogLineParserImpl<NMT_MallocRecord>(NMT_MallocRecord.class);
                    NMT_LogRecord result = logLineParser.parseLine(logTokens);
                    List<String> mallocs = ((NMT_ParserState)this.state).getSavedMallocs();
                    for (String malloc : mallocs) {
                        result.updateField("malloc stack", malloc);
                    }
                    ((NMT_ParserState)this.state).clearSavedMallocs();
                    records.add(result);
                    gotFullRecord = true;
                    break;
                }
            }
        }
        if (gotFullRecord) {
            return records;
        }
        return null;
    }

    private List<String> getTokens(String line) {
        Pattern pattern;
        Matcher matcher;
        if (line.isEmpty()) {
            return null;
        }
        if (line.contains("Native Memory Tracking:")) {
            ((NMT_ParserState)this.state).setState(State.SUMMARY);
        }
        if (line.contains("Details:")) {
            ((NMT_ParserState)this.state).setState(State.DETAILS);
        }
        if (line.contains("malloc=") && ((NMT_ParserState)this.state).getState() != State.SUMMARY) {
            ((NMT_ParserState)this.state).setState(State.MALLOC_END);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int start = line.indexOf(91);
        int end = line.indexOf(93);
        if (start >= 0 && end > start) {
            tokens.add(line.substring(start + 1, end));
        } else if (((NMT_ParserState)this.state).getState() != State.DETAILS && ((NMT_ParserState)this.state).getState() != State.MALLOC_END && ((NMT_ParserState)this.state).getState() != State.MALLOC_STACK) {
            return null;
        }
        if (line.contains(" reserved ")) {
            ((NMT_ParserState)this.state).setState(State.MMAP_RESERVED);
        }
        if (line.contains(" committed ")) {
            if (((NMT_ParserState)this.state).getState() == State.MMAP_RESERVED) {
                ((NMT_ParserState)this.state).setState(State.MMAP_BOTH);
            } else {
                ((NMT_ParserState)this.state).setState(State.MMAP_COMMITED);
            }
        }
        if ((matcher = (pattern = Pattern.compile("\\b(?:reserved|committed|\\w+=)\\s*(\\d+)(?:([KMGT]B))?\\b")).matcher(line)).find()) {
            String number = matcher.group(1);
            String suffix = matcher.group(2);
            String result = suffix != null ? number + suffix : number;
            tokens.add(result);
        }
        if ((matcher = (pattern = Pattern.compile("(?:\\sfor\\s)(.*)(?:.*)")).matcher(line)).find()) {
            tokens.add(matcher.group(1).trim().replace(" from", ""));
        }
        if ((matcher = (pattern = Pattern.compile("(?:type=)(.*)(?:#)")).matcher(line)).find()) {
            String group = matcher.group(1).trim();
            int idx = group.indexOf(35);
            if (idx > 0) {
                tokens.add(group.substring(0, idx).trim());
            } else {
                tokens.add(group);
            }
        }
        if ((matcher = (pattern = Pattern.compile("(?:\\s#)([0-9]+)")).matcher(line)).find()) {
            tokens.add(matcher.group(1));
        }
        if (tokens.size() == 1) {
            switch (((NMT_ParserState)this.state).getState()) {
                case MMAP_RESERVED: {
                    ((NMT_ParserState)this.state).setState(State.MMAP_RESERVED_STACK);
                    break;
                }
                case MMAP_COMMITED: {
                    ((NMT_ParserState)this.state).setState(State.MMAP_COMMITED_STACK);
                    break;
                }
                case MMAP_BOTH: {
                    ((NMT_ParserState)this.state).setState(State.MMAP_BOTH_STACK);
                    break;
                }
                case DETAILS: 
                case MALLOC_END: {
                    ((NMT_ParserState)this.state).setState(State.MALLOC_STACK);
                }
            }
            tokens.remove(0);
            tokens.add(line);
        }
        return tokens;
    }
}

