/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.LogLineWithTime;
import java.util.HashMap;
import java.util.Map;

public class ParserState {
    private LogLineWithTime currentLine;
    private int currentLineNumber;
    private final Map<Class<?>, LogRecord> lastRecords = new HashMap();
    private final LogTimeModel logTimeModel = new LogTimeModel();
    private AbsoluteTimestamp currentLineAbsoluteTimestamp = null;
    private RelativeTimestamp currentLineRelativeTimestamp = null;

    protected ParserState() {
    }

    public LogLineWithTime getCurrentLine() {
        return this.currentLine;
    }

    void setCurrentLogLine(int lineNumber, LogLineWithTime logLineWithTime) {
        this.currentLineNumber = lineNumber;
        this.currentLine = logLineWithTime;
        this.setCurrentLineRelativeTimestamp(logLineWithTime.getRelativeTimestamp());
        this.setCurrentLineAbsoluteTimestamp(logLineWithTime.getAbsoluteTimestamp());
        this.syncCurrentTimestamps();
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    public void resetCurrentTimestamps() {
        this.currentLineAbsoluteTimestamp = null;
        this.currentLineRelativeTimestamp = null;
    }

    public LogTimeModel getLogTimeModel() {
        return this.logTimeModel;
    }

    private void syncCurrentTimestamps() {
        if (this.currentLineAbsoluteTimestamp == null && this.currentLineRelativeTimestamp == null) {
            return;
        }
        if (this.currentLineAbsoluteTimestamp != null && this.currentLineRelativeTimestamp != null) {
            return;
        }
        if (this.logTimeModel.getAbsoluteTimestampBase() != null) {
            if (this.currentLineAbsoluteTimestamp == null) {
                this.setCurrentLineAbsoluteTimestamp(this.logTimeModel.getAbsoluteTimestampBase().shift(this.currentLineRelativeTimestamp.getInUnits(LogUnits.NANOSECONDS), LogUnits.NANOSECONDS));
            } else {
                double delta_ns = AbsoluteTimestamp.delta(this.currentLineAbsoluteTimestamp, this.logTimeModel.getAbsoluteTimestampBase(), LogUnits.NANOSECONDS);
                this.setCurrentLineRelativeTimestamp(RelativeTimestamp.of(delta_ns, LogUnits.NANOSECONDS));
            }
        }
    }

    private void setCurrentLineAbsoluteTimestamp(AbsoluteTimestamp absoluteTimestamp) {
        if (absoluteTimestamp != null) {
            this.currentLineAbsoluteTimestamp = absoluteTimestamp;
            this.logTimeModel.processAbsoluteTimestamp(this.currentLineAbsoluteTimestamp);
        }
    }

    private void setCurrentLineRelativeTimestamp(RelativeTimestamp relativeTimestamp) {
        if (relativeTimestamp != null) {
            this.currentLineRelativeTimestamp = relativeTimestamp;
            this.logTimeModel.processRelativeTimestamp(relativeTimestamp);
        }
    }

    public RelativeTimestamp getCurrentLineRelativeTimestamp() {
        if (this.currentLineRelativeTimestamp == null && this.currentLineAbsoluteTimestamp == null) {
            return this.logTimeModel.getLastEventRelativeTimestamp();
        }
        if (this.currentLineRelativeTimestamp == null && this.currentLineAbsoluteTimestamp != null) {
            this.currentLineRelativeTimestamp = this.logTimeModel.toRelative(this.currentLineAbsoluteTimestamp);
        }
        return this.currentLineRelativeTimestamp;
    }

    public AbsoluteTimestamp getCurrentLineAbsoluteTimestamp() {
        return this.currentLineAbsoluteTimestamp;
    }

    public <T extends LogRecord> T getLastRecordOfType(Class<T> klass) {
        return (T)this.lastRecords.get(klass);
    }

    <T extends LogRecord> void setLastRecord(T record) {
        this.lastRecords.put(record.getClass(), record);
        this.logTimeModel.processRelativeTimestamp(record.getEventRelativeTimestamp());
    }
}

