/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.support;

import com.azul.log.model.api.LogModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class SingleFileLogModel
extends LogModel {
    private final Path file;

    public SingleFileLogModel(String id, Path file) {
        super(id);
        this.file = file;
    }

    @Override
    protected long calculateLogSize() throws IOException {
        return Files.size(this.file);
    }

    @Override
    protected String calculateLogName() {
        return this.file.getFileName().toString();
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public List<Path> getPaths() {
        return Collections.singletonList(this.file);
    }
}

