/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.utils;

public final class CharSequenceTokenizer {
    private final byte[] sep_cache = new byte[256];
    private final String separators;
    private CharSequence line;
    private int pos;
    private int length;

    public CharSequenceTokenizer(String separators) {
        this.separators = separators;
        for (int i = 0; i < separators.length(); ++i) {
            this.sep_cache[separators.charAt((int)i) % 256] = 1;
        }
    }

    public void init(CharSequence line) {
        this.line = line;
        this.pos = 0;
        this.length = line.length();
        this.skipSeparators();
    }

    private void skipSeparators() {
        char c;
        while (this.pos < this.length && this.sep_cache[(c = this.line.charAt(this.pos)) % 256] != 0 && this.separators.indexOf(c) >= 0) {
            ++this.pos;
        }
    }

    public boolean hasMoreTokens() {
        return this.pos < this.length;
    }

    public int getPosition() {
        return this.pos;
    }

    public CharSequence nextToken() {
        char c;
        int i;
        for (i = this.pos + 1; i < this.length && (this.sep_cache[(c = this.line.charAt(i)) % 256] == 0 || this.separators.indexOf(c) < 0); ++i) {
        }
        CharSequence res = this.line.subSequence(this.pos, i);
        this.pos = i;
        this.skipSeparators();
        return res;
    }

    public CharSequence remainder() {
        return this.line.subSequence(this.pos, this.length);
    }
}

