/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.utils;

import com.azul.log.utils.ProgressModel;
import com.azul.log.utils.ProgressMonitorInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mjson.Json;

public final class CommonUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final Method base64DecodeMethod;
    private static final Object base64Decoder;
    private static final Method base64EncodeMethod;
    private static final Object base64Encoder;
    private static final Path tmpDir;

    private CommonUtils() {
    }

    public static boolean isLinux() {
        return OS.contains("linux");
    }

    public static boolean isMacOSX() {
        return OS.startsWith("mac os x");
    }

    public static <T> Predicate<T> not(Predicate<T> p) {
        return p.negate();
    }

    public static Path downloadFile(URI from, Path to, ProgressModel progressModel) throws IOException {
        HttpURLConnection con = (HttpURLConnection)from.toURL().openConnection();
        con.setRequestMethod("GET");
        try {
            Path path;
            block13: {
                InputStream is = progressModel == null ? con.getInputStream() : new ProgressMonitorInputStream(progressModel, con.getInputStream(), con.getContentLengthLong());
                try {
                    Files.copy(is, to, StandardCopyOption.REPLACE_EXISTING);
                    path = to;
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UnknownHostException ex) {
                        throw new IOException("Failed to download " + from + ": host " + ex.getMessage() + " is unknown");
                    }
                    catch (IOException ex) {
                        throw new IOException("Failed to download " + from + ": " + con.getResponseMessage());
                    }
                }
                is.close();
            }
            return path;
        }
        finally {
            con.disconnect();
            if (progressModel != null && progressModel.isCanceled()) {
                Files.delete(to);
                Files.delete(to.getParent());
            }
        }
    }

    public static byte[] decodeBase64(String data) {
        try {
            return (byte[])base64DecodeMethod.invoke(base64Decoder, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new InternalError("No Base64 support");
        }
    }

    public static String encodeBase64(byte[] data) {
        try {
            String result = (String)base64EncodeMethod.invoke(base64Encoder, new Object[]{data});
            return result.replace("\n", "").replace("\r", "");
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new InternalError("No Base64 support");
        }
    }

    public static ZoneId guessTimeZone(long timestamp, CharSequence time) {
        ZoneId zoneId;
        int[] fld_idx;
        String[] chunks = time.toString().split(" +");
        if (chunks.length != 6 && chunks.length != 7) {
            return null;
        }
        String tz_abbr = chunks[chunks.length - 2];
        if (tz_abbr.startsWith("+") || tz_abbr.startsWith("-")) {
            return ZoneId.of("GMT" + tz_abbr);
        }
        String hms = chunks.length == 6 ? chunks[3] : chunks[3] + " " + chunks[4];
        SimpleDateFormat df = chunks.length == 6 ? new SimpleDateFormat("HH:mm:ss", Locale.ROOT) : new SimpleDateFormat("hh:mm:ss a", Locale.ROOT);
        Date date = new Date(timestamp);
        for (int i : fld_idx = new int[]{0, 2, 4}) {
            zoneId = CommonUtils.timeZoneIdLookup(hms, df, date, tz_abbr, i);
            if (zoneId == null) continue;
            return zoneId;
        }
        for (int i : fld_idx) {
            zoneId = CommonUtils.timeZoneIdLookup(hms, df, date, null, i);
            if (zoneId == null) continue;
            return zoneId;
        }
        return null;
    }

    private static ZoneId timeZoneIdLookup(String hms, DateFormat df, Date date, String tz, int idx) {
        DateFormatSymbols symbols = DateFormatSymbols.getInstance();
        for (String[] zi : symbols.getZoneStrings()) {
            if (tz != null && !tz.equals(zi[idx])) continue;
            TimeZone zone = TimeZone.getTimeZone(zi[0]);
            df.setTimeZone(zone);
            String hms_from_tz = df.format(date);
            if (!hms_from_tz.equals(hms)) continue;
            return zone.toZoneId();
        }
        return null;
    }

    public static String inputStreamToString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
    }

    public static Json readJSON(URI uri) throws IOException {
        Path path = uri.getScheme() == null || "file".equals(uri.getScheme()) ? new File(uri).toPath() : CommonUtils.downloadFile(uri, CommonUtils.createTempFileForURI(uri), null);
        return Files.isReadable(path) ? Json.read(path.toUri().toURL()) : null;
    }

    public static Path getTempDir() {
        return tmpDir;
    }

    public static Path createTempFileForURI(URI uri) throws IOException {
        String fname = uri.getPath();
        fname = fname.substring(fname.lastIndexOf("/") + 1);
        Path path = CommonUtils.getTempDir().resolve(fname);
        Files.deleteIfExists(path);
        return Files.createFile(path, new FileAttribute[0]);
    }

    public static List<String> getLaunchCommand(List<String> javaOptions, List<String> commandLineOptions) {
        try {
            CodeSource source = CommonUtils.class.getProtectionDomain().getCodeSource();
            String jarPath = Paths.get(source.getLocation().toURI()).toString();
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            ArrayList<String> command = new ArrayList<String>();
            Path bin = Paths.get(System.getProperty("java.home"), "bin");
            command.add(bin.resolve("java").toFile().toString());
            command.addAll(runtimeMxBean.getInputArguments());
            command.addAll(javaOptions);
            if (jarPath.endsWith(".jar")) {
                command.add("-jar");
                command.add(jarPath);
            } else {
                command.add("-cp");
                command.add(runtimeMxBean.getClassPath());
                command.add(CommonUtils.class.getCanonicalName());
            }
            if (commandLineOptions != null) {
                command.addAll(commandLineOptions);
            }
            return command;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            tmpDir = Files.createTempDirectory("gcla", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try (Stream<Path> walk = Files.walk(tmpDir, new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Method decodeMethod = null;
        Object decoder = null;
        Method encodeMethod = null;
        Object encoder = null;
        try {
            try {
                Class<?> decoderClass = Class.forName("sun.misc.BASE64Decoder");
                Class<?> encoderClass = Class.forName("sun.misc.BASE64Encoder");
                decoder = decoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                encoder = encoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                decodeMethod = decoderClass.getMethod("decodeBuffer", String.class);
                encodeMethod = encoderClass.getMethod("encode", byte[].class);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException decoderClass) {
                try {
                    Class<?> converterClass = Class.forName("javax.xml.bind.DatatypeConverter");
                    decodeMethod = converterClass.getDeclaredMethod("parseBase64Binary", String.class);
                    encodeMethod = converterClass.getDeclaredMethod("printBase64Binary", byte[].class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException converterClass) {
                    try {
                        Class<?> base64Class = Class.forName("java.util.Base64");
                        Method getDecoderMethod = base64Class.getDeclaredMethod("getDecoder", new Class[0]);
                        Method getEncoderMethod = base64Class.getDeclaredMethod("getEncoder", new Class[0]);
                        decoder = getDecoderMethod.invoke(null, new Object[0]);
                        encoder = getEncoderMethod.invoke(null, new Object[0]);
                        decodeMethod = decoder.getClass().getDeclaredMethod("decode", String.class);
                        encodeMethod = encoder.getClass().getDeclaredMethod("encodeToString", byte[].class);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            base64DecodeMethod = decodeMethod;
            base64Decoder = decoder;
            base64EncodeMethod = encodeMethod;
            base64Encoder = encoder;
        }
    }
}

