/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer;

import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.parser.utils.TextUtils;
import com.azul.loganalyzer.cli.ArgsParam;
import com.azul.loganalyzer.cli.ArgsSwitch;
import com.azul.loganalyzer.cli.ArgumentException;
import com.azul.loganalyzer.cli.CommandLineArguments;
import java.net.URI;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class Arguments
extends CommandLineArguments {
    public final List<URI> uris = new ArrayList<URI>();
    @ArgsSwitch(keys={"-h", "--help"}, help="Print out usage information and exit")
    public boolean help = false;
    @ArgsSwitch(keys={"-v", "--version"}, help="Print out version information and exit")
    public boolean version = false;
    @ArgsParam(keys={"--generate-html"}, param="dir", isOptional=true, help="Generate simple HTML page with all the graphs extracted from the GC Log and exit")
    public String htmlDumpDir;
    @ArgsParam(keys={"--image-size"}, param="dimensions", isOptional=true, help="Resize generated PNG image files to the specified dimensions")
    public String dimensions;
    @ArgsParam(keys={"--process-matched-sequences", "-m"}, param="yes|no|ask", isOptional=true, help="Either process a single log file or all logs from the same run (rotated sequences) found")
    public String processMatchedSequences;
    @ArgsParam(keys={"--dump-raw-data"}, param="file", isOptional=true, help="Dump all data extracted from the log in json format and exit")
    public String dumpRawDataFile;
    @ArgsParam(keys={"--font-size"}, param="font", isOptional=true, help="Font Size of UI elements")
    public Integer fontSize;
    @ArgsSwitch(keys={"-e", "--experimental"}, help="Enable experimental features (if any)")
    public boolean enableExperimentalFeatures = false;
    public int width = 1024;
    public int height = 768;

    public Arguments(String[] arguments, String jarName, String helpResource) {
        super(arguments, jarName, helpResource);
    }

    private static URI toURI(String uri) {
        return uri == null ? null : (uri.contains("://") ? URI.create(uri) : Paths.get(uri, new String[0]).toAbsolutePath().normalize().toUri());
    }

    @Override
    protected void validate(List<String> remaining) throws ArgumentException {
        if (this.version) {
            System.out.println("GCLogAnalyzer version: 25.12.0-ca");
            System.exit(0);
        }
        if (this.htmlDumpDir == null && this.dimensions != null) {
            throw new ArgumentException("--image-size requires --generate-html");
        }
        if (this.dimensions != null) {
            int p = this.dimensions.indexOf(120);
            boolean parsed = false;
            if (p > 0) {
                try {
                    Integer w = TextUtils.parseInt(this.dimensions.subSequence(0, p));
                    Integer h = TextUtils.parseInt(this.dimensions.subSequence(p + 1, this.dimensions.length()));
                    if (w != null && h != null) {
                        this.width = w;
                        this.height = h;
                        parsed = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!parsed) {
                throw new ArgumentException("dimensions should be specified in the following format: <width>x<height>, where <width> and <height> are integer numbers");
            }
        }
        if (this.fontSize != null && (this.fontSize < 6 || this.fontSize > 32)) {
            throw new ArgumentException("Value " + this.fontSize + " of the --font-size parameter is not within its valid range 6 to 32.");
        }
        for (String arg : remaining) {
            if (!arg.startsWith("-")) continue;
            throw new ArgumentException("Unknown option: " + arg);
        }
        if (this.processMatchedSequences != null && this.htmlDumpDir == null && this.dumpRawDataFile == null) {
            System.err.println("Warning: --process-matched-sequences/-m flag is ignored when GCLA2 is started in UI mode");
        }
        this.uris.addAll(remaining.stream().map(Arguments::toURI).collect(Collectors.toList()));
    }

    @Override
    protected String describeEnumConstant(Enum<?> value) {
        if (DisplayTimeModel.TZone.class.equals(value.getDeclaringClass())) {
            DisplayTimeModel.TZone v = (DisplayTimeModel.TZone)value;
            switch (v) {
                case FILE: {
                    return "TimeZone from the GC Log File (default).";
                }
                case UTC: {
                    return "Coordinated Universal Time.";
                }
                case SYSTEM: {
                    return "System TimeZone (currently set to " + ZoneId.systemDefault() + "). Could be set with -Duser.timezone=<zone> java option.";
                }
                case USER: {
                    return null;
                }
            }
            throw new InternalError();
        }
        if (DisplayTimeModel.Units.class.equals(value.getDeclaringClass())) {
            DisplayTimeModel.Units v = (DisplayTimeModel.Units)value;
            switch (v) {
                case ABSOLUTE: {
                    return "Absolute time in TimeZone, specified with the --time-zone (default time zone is 'file').";
                }
                case AUTO: {
                    return "Elapsed time in human-readable format.";
                }
                case SECONDS: {
                    return "Elapsed time in seconds (default).";
                }
                case MINUTES: {
                    return "Elapsed time in minutes.";
                }
                case HOURS: {
                    return "Elapsed time in hours.";
                }
            }
            throw new InternalError();
        }
        return super.describeEnumConstant(value);
    }
}

