/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer;

import com.azul.log.gui.config.api.Config;
import com.azul.loganalyzer.Arguments;
import com.azul.loganalyzer.LogAnalyzerGuiImpl;
import com.azul.loganalyzer.LogAnalyzerHeadlessImpl;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Main {
    public static void main(String[] arguments) {
        Locale.setDefault(Locale.US);
        Config.init();
        Arguments args = new Arguments(arguments, "GCLogAnalyzer-25.12.0-ca.jar", "/usage.txt");
        try {
            args.parse();
            if (args.help) {
                args.printUsage();
                System.exit(0);
            }
            Main.start(args);
        }
        catch (Exception ex) {
            if (args.help) {
                args.printUsage();
                System.exit(0);
            }
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex.getMessage());
            ex.printStackTrace(System.err);
            System.out.println();
            args.printUsage();
            System.exit(1);
        }
    }

    private static void start(Arguments args) throws Exception {
        boolean uiMode;
        boolean bl = uiMode = args.htmlDumpDir == null && args.dumpRawDataFile == null;
        if (uiMode) {
            new LogAnalyzerGuiImpl(args).start();
        } else {
            if (args.uris.isEmpty()) {
                System.err.println("ERROR: No log file provided.");
                args.printUsage();
                System.exit(1);
            }
            new LogAnalyzerHeadlessImpl(args).start();
        }
    }
}

