/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer.cli.dump.html;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.utils.jfreechart.ChartEx;
import com.azul.log.gui.utils.jfreechart.JFreeChartSupport;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.model.spi.LogSummary;
import com.azul.log.utils.ProgressModel;
import com.azul.loganalyzer.Arguments;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.data.json.impl.JSONObject;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class HTMLDumper {
    private final LogFilesModel logFilesModel;
    private final Arguments args;
    private final ProgressModel progressModel;

    private HTMLDumper(LogFilesModel logFilesModel, Arguments args, ProgressModel progressModel) {
        this.logFilesModel = logFilesModel;
        this.args = args;
        this.progressModel = progressModel;
    }

    public static void dump(LogFilesModel logFilesModel, Arguments args, ProgressModel progressModel) throws IOException {
        new HTMLDumper(logFilesModel, args, progressModel).dump();
    }

    private void dump() throws IOException {
        Path outputDir = new File(this.args.htmlDumpDir).getAbsoluteFile().toPath();
        this.createDirs(outputDir);
        this.dumpAllGraphsHtml(outputDir);
        this.dumpGraphsJS(outputDir);
        this.dumpGraphsPNG(outputDir.resolve("png-files"));
        this.copyResource("scripts.js", outputDir);
        this.copyResource("style.css", outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dumpGraphsPNG(Path outputDir) throws IOException {
        this.createDirs(outputDir);
        List<LogFile> logFiles = this.logFilesModel.getLogFiles();
        int charts = logFiles.stream().map(f -> f.lookup(PlotData.class)).filter(Objects::nonNull).mapToInt(PlotData::getGraphsCount).sum();
        this.progressModel.setMaximum(charts);
        ExecutorService exec = Executors.newWorkStealingPool(10);
        try {
            MarksModel marksModel = MarksModel.create(logFiles);
            for (LogFile logFile : logFiles) {
                PlotData data = logFile.lookup(PlotData.class);
                if (data == null) continue;
                Context.setContext(Lookups.fixed(marksModel, DisplayTimeModel.create(logFile.lookup(LogTimeModel.class))));
                int count = data.getGraphsCount();
                CountDownLatch latch = new CountDownLatch(count);
                for (int i = 0; i < count; ++i) {
                    GraphDefinition gd = data.getGraphDefinition(i);
                    String fileName = gd.getDefaultSaveAsFileName() + ".png";
                    exec.submit(() -> {
                        try {
                            ChartEx chart = JFreeChartSupport.createXYGraph(gd, false, true);
                            BufferedImage bufferedImage = chart.getChart().createBufferedImage(this.args.width, this.args.height, 1024.0, 768.0, new ChartRenderingInfo());
                            Path outputFile = outputDir.resolve(fileName);
                            try (OutputStream out = Files.newOutputStream(outputFile, new OpenOption[0]);){
                                EncoderUtil.writeBufferedImage(bufferedImage, "png", out);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            this.progressModel.addProgress(1L);
                            latch.countDown();
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            exec.shutdownNow();
        }
    }

    private void dumpGraphsJS(Path outputDir) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(outputDir.resolve("graphs.js"), Charset.defaultCharset(), new OpenOption[0]);){
            bw.append("var graphs = {\"graphs\": [");
            boolean first = true;
            for (LogFile logFile : this.logFilesModel.getLogFiles()) {
                final PlotData data = logFile.lookup(PlotData.class);
                if (data == null) continue;
                int count = data.getGraphsCount();
                for (int i = 0; i < count; ++i) {
                    final GraphDefinition gd = data.getGraphDefinition(i);
                    final int idx = i;
                    bw.newLine();
                    if (first) {
                        first = false;
                    } else {
                        bw.append(',');
                    }
                    JSONObject.writeJSONString(new HashMap<String, String>(){
                        {
                            this.put("id", Integer.toHexString(gd.getID()));
                            this.put("category", data.getGraphCategory(idx));
                            this.put("title", data.getGraphName(idx));
                            this.put("fname", gd.hasData() ? gd.getDefaultSaveAsFileName() + ".png" : "nodata");
                        }
                    }, bw);
                }
            }
            bw.newLine();
            bw.append("]}");
        }
    }

    private void dumpAllGraphsHtml(Path outputDir) throws IOException {
        try (InputStream is = HTMLDumper.class.getResourceAsStream("/html/all-graphs.html");
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);
             BufferedWriter bw = Files.newBufferedWriter(outputDir.resolve("all-graphs.html"), Charset.defaultCharset(), new OpenOption[0]);){
            String line;
            while ((line = br.readLine()) != null) {
                switch (line.trim()) {
                    case "@SUMMARY@": {
                        this.writeSummary(this.logFilesModel, bw);
                        break;
                    }
                    case "@FOOTER@": {
                        this.writeFooter(bw);
                        break;
                    }
                    default: {
                        bw.append(line.replace("@TITLE@", this.getTitle(this.logFilesModel)));
                    }
                }
                bw.newLine();
            }
        }
    }

    private void copyResource(String resource, Path outputDir) throws IOException {
        try (InputStream is = HTMLDumper.class.getResourceAsStream("/html/" + resource);){
            if (is != null) {
                Files.copy(is, outputDir.resolve(resource), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void writeFooter(BufferedWriter bw) throws IOException {
        bw.append("Generated using GCLogAnalyzer version: 25.12.0-ca");
    }

    private void writeSummary(LogFilesModel logFilesModel, final BufferedWriter bw) throws IOException {
        LogFile logFile = logFilesModel.getLogFiles().stream().filter(f -> f.lookup(LogSummary.class) != null).findFirst().orElse(null);
        if (logFile == null) {
            return;
        }
        Context.setContext(new ProxyLookup(logFile.getLookup(), Lookups.fixed(DisplayTimeModel.create(logFile.lookup(LogTimeModel.class)))));
        LogSummaryToUIModelConverter summaryConverter = LogSummaryToUIModelConverter.create();
        bw.append("<pre><table class=\"info\">");
        if (summaryConverter != null) {
            summaryConverter.convert(new LogSummaryToUIModelConverter.Callback(){

                @Override
                public void addSection(String sectionName) {
                    try {
                        bw.append("<tr><td class=\"section\" colspan=\"2\">");
                        bw.append(sectionName).append("</td></tr>");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void addIndent() {
                    try {
                        bw.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void addValue(String name, Object value) {
                    try {
                        bw.append("<tr><td>").append(name).append("</td><td>");
                        bw.append(value == null ? "n/a" : value.toString()).append("</td></tr>");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        bw.append("</table></pre>");
    }

    private String getTitle(LogFilesModel logFilesModel) {
        return logFilesModel.getLogFiles().get(0).lookup(LogModel.class).getLogName();
    }

    private void createDirs(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
    }
}

