/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer.cli.dump.json;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.model.spi.LogDataConverter;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import com.azul.log.utils.ProgressModel;
import com.azul.loganalyzer.cli.dump.json.JSONWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class JSONDumper {
    private static final StringBuilder buf = new StringBuilder("[");
    private static final Formatter fmt = new Formatter(buf, Locale.US);
    private final ProgressModel progressModel;
    private final LogFilesModel logFilesModel;
    private final int numberOfBuckets;
    private final JSONWriter writer;

    private JSONDumper(LogFilesModel logFilesModel, JSONWriter writer, int numberOfBuckets, ProgressModel progressModel) {
        this.logFilesModel = logFilesModel;
        this.writer = writer;
        this.numberOfBuckets = numberOfBuckets;
        this.progressModel = progressModel;
    }

    public static void dump(LogFilesModel logFilesModel, OutputStream out, int numberOfBuckets, ProgressModel progressModel) throws IOException {
        if (!logFilesModel.getLogFiles().isEmpty()) {
            try (JSONWriter writer = JSONWriter.formatted(out);){
                new JSONDumper(logFilesModel, writer, numberOfBuckets, progressModel).dump();
            }
        }
    }

    private void dump() {
        this.progressModel.setMaximum(this.graphDefinitions().count());
        this.dumpSummary();
        this.dumpAvailableCharts();
        this.dumpGraphDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSummary() {
        LogFile logFile = this.logFilesModel.getLogFiles().get(0);
        Context.setContext(new ProxyLookup(logFile.getLookup(), Lookups.fixed(DisplayTimeModel.create(logFile.lookup(LogTimeModel.class)))));
        LogSummaryToUIModelConverter summaryConverter = LogSummaryToUIModelConverter.create();
        if (summaryConverter != null) {
            LogFactsCollector logFactsCollector = new LogFactsCollector();
            summaryConverter.convert(logFactsCollector);
            try {
                this.writer.startObject("summary");
                this.writer.dumpObject("facts", logFactsCollector.facts);
            }
            finally {
                this.writer.endObject();
            }
        }
    }

    private void dumpAvailableCharts() {
        String fmt = "{'c':'%s','n':'%s','id':'%s'}".replace('\'', '\"');
        this.writeArray("available_charts", () -> this.writer.println(this.graphDefinitions().map(gd -> String.format(fmt, gd.getCategoryName(), gd.getTitle(), gd.getDefaultSaveAsFileName())).collect(Collectors.joining(","))));
    }

    private void dumpGraphDefinitions() {
        TimeUnit relativeTimeUnits = TimeUnit.SECONDS;
        LogTimeModel compoundTimeModel = LogTimeModel.getCompoundLogTimeModelAndFixupLogModels(this.logFilesModel.getLogFiles());
        double start_ts = compoundTimeModel.getLastEventRelativeTimestamp().getInUnits(relativeTimeUnits);
        double end_ts = compoundTimeModel.getFirstEventRelativeTimestamp().getInUnits(relativeTimeUnits);
        double bucket_len = (start_ts - end_ts) / (double)this.numberOfBuckets;
        this.writeArray("graphs", () -> this.logFilesModel.getLogFiles().forEach(f -> {
            LogModel logModel = f.lookup(LogModel.class);
            this.writer.startObject(null);
            this.writer.dumpObject("logName", logModel.getLogName());
            this.writer.startArray("files");
            this.writer.println(logModel.getPaths().stream().map(p -> "\"" + p.toString() + "\"").collect(Collectors.joining(",")));
            this.writer.endArray();
            PlotData plotData = f.lookup(PlotData.class);
            this.writer.startArray("charts");
            TimeAdjustmentSupport.withLogModel(logModel, () -> plotData.getGraphDefinitions().forEach(gd -> this.dumpGraphDefinition((GraphDefinition)gd, start_ts, end_ts, bucket_len, relativeTimeUnits)));
            this.writer.endArray();
            this.writer.endObject();
        }));
    }

    private void dumpGraphDefinition(GraphDefinition gd, double start_ts, double end_ts, double bucket_len, TimeUnit relativeTimeUnits) {
        this.writer.startObject(null);
        this.writer.dumpObject("id", gd.getDefaultSaveAsFileName());
        this.writer.dumpObject("category", gd.getCategoryName());
        this.writer.dumpObject("name", gd.getTitle());
        this.writer.dumpObject("time_units", relativeTimeUnits.name().toLowerCase());
        this.writer.dumpObject("data_label", gd.getYLabel());
        this.writer.dumpObject("data_units", gd.getUnits().name().toLowerCase());
        LogRecordLabelConverter labelsConverter = gd.getLabelConverter();
        if (labelsConverter != null) {
            this.writer.dumpObject("ylabels", labelsConverter.getLabels());
        }
        this.writer.startArray("series");
        gd.getGraphData().forEach(ser -> {
            LogDataConverter converter = ser.getConverter();
            this.writer.startObject(null);
            this.writer.dumpObject("name", ser.getLabel());
            Color color = ser.getColor();
            this.writer.dumpObject("color", String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
            this.writer.startArray("data");
            Double in_ts = null;
            Double in_val = null;
            Double out_ts = null;
            Double out_val = null;
            Double min_ts = null;
            Double min_val = null;
            Double max_ts = null;
            Double max_val = null;
            int bucketNo = 0;
            LogRecordsList<LogRecord> records = ser.getData();
            for (LogRecord record : records) {
                double r_ts = record.getEventRelativeTimestamp(relativeTimeUnits);
                double r_value = converter.getValue(record);
                int r_bucket = (int)((r_ts - start_ts) / bucket_len);
                if (r_bucket != bucketNo) {
                    if (in_ts != null) {
                        double ts = in_ts;
                        this.outDataPoint(this.writer, in_ts, in_val);
                        if (min_ts < max_ts) {
                            if (min_ts > ts) {
                                this.outDataPoint(this.writer, min_ts, min_val);
                                ts = min_ts;
                            }
                            if (max_ts > ts) {
                                this.outDataPoint(this.writer, max_ts, max_val);
                                ts = max_ts;
                            }
                        } else {
                            if (max_ts > ts) {
                                this.outDataPoint(this.writer, max_ts, max_val);
                                ts = max_ts;
                            }
                            if (min_ts > ts) {
                                this.outDataPoint(this.writer, min_ts, min_val);
                                ts = min_ts;
                            }
                        }
                        if (out_ts > ts) {
                            this.outDataPoint(this.writer, out_ts, out_val);
                        }
                    }
                    bucketNo = r_bucket;
                    in_ts = r_ts;
                    in_val = r_value;
                    out_ts = r_ts;
                    out_val = r_value;
                    min_ts = r_ts;
                    min_val = r_value;
                    max_ts = r_ts;
                    max_val = r_value;
                    continue;
                }
                if (in_ts == null) {
                    in_ts = r_ts;
                    in_val = r_value;
                    out_ts = r_ts;
                    out_val = r_value;
                    min_ts = r_ts;
                    min_val = r_value;
                    max_ts = r_ts;
                    max_val = r_value;
                    continue;
                }
                out_ts = r_ts;
                out_val = r_value;
                if (min_val > r_value) {
                    min_ts = r_ts;
                    min_val = r_value;
                }
                if (!(max_val < r_value)) continue;
                max_ts = r_ts;
                max_val = r_value;
            }
            if (in_ts != null) {
                double ts = in_ts;
                this.outDataPoint(this.writer, in_ts, in_val);
                if (min_ts < max_ts) {
                    if (min_ts > ts) {
                        this.outDataPoint(this.writer, min_ts, min_val);
                        ts = min_ts;
                    }
                    if (max_ts > ts) {
                        this.outDataPoint(this.writer, max_ts, max_val);
                        ts = max_ts;
                    }
                } else {
                    if (max_ts > ts) {
                        this.outDataPoint(this.writer, max_ts, max_val);
                        ts = max_ts;
                    }
                    if (min_ts > ts) {
                        this.outDataPoint(this.writer, min_ts, min_val);
                        ts = min_ts;
                    }
                }
                if (out_ts > ts) {
                    this.outDataPoint(this.writer, out_ts, out_val);
                }
            }
            this.writer.endArray();
            this.writer.endObject();
        });
        this.writer.endArray();
        this.writer.endObject();
        this.progressModel.addProgress(1L);
    }

    private void outDataPoint(JSONWriter writer, double ts, double val) {
        buf.setLength(1);
        fmt.format("%.3f", ts);
        int l = buf.length() - 1;
        char c = buf.charAt(l);
        while (c == '0') {
            buf.setLength(l--);
            c = buf.charAt(l);
        }
        if (c == '.') {
            buf.setLength(l--);
        }
        buf.append(',');
        fmt.format("%.4f", val);
        l = buf.length() - 1;
        c = buf.charAt(l);
        while (c == '0') {
            buf.setLength(l--);
            c = buf.charAt(l);
        }
        if (c == '.') {
            buf.setLength(l--);
        }
        buf.append("],");
        writer.println(buf.toString());
    }

    private Stream<GraphDefinition> graphDefinitions() {
        return this.logFilesModel.getLogFiles().stream().map(f -> f.lookup(PlotData.class)).filter(Objects::nonNull).map(PlotData::getGraphDefinitions).flatMap(Collection::stream);
    }

    private void writeArray(String name, Runnable elementsWriter) {
        try {
            this.writer.startArray(name);
            elementsWriter.run();
        }
        finally {
            this.writer.endArray();
        }
    }

    private static final class LogFacts
    extends LinkedHashMap<String, LinkedHashMap<String, String>> {
        private LogFacts() {
        }

        public void put(String section, String name, String value) {
            LinkedHashMap<String, String> sectionsMap = (LinkedHashMap<String, String>)this.get(section);
            if (sectionsMap == null) {
                sectionsMap = new LinkedHashMap<String, String>();
                this.put(section, sectionsMap);
            }
            sectionsMap.put(name, value);
        }
    }

    private static class LogFactsCollector
    extends LogSummaryToUIModelConverter.Callback {
        private final LogFacts facts = new LogFacts();
        private String currentSection = null;

        private LogFactsCollector() {
        }

        @Override
        public void addSection(String sectionName) {
            this.currentSection = sectionName;
        }

        @Override
        public void addIndent() {
        }

        @Override
        public void addValue(String name, Object value) {
            this.facts.put(this.currentSection, name, value == null ? "n/a" : value.toString());
        }
    }
}

